package com.paytm.pgsdk;

/**
 * This class contains member variables holding the Refund related Information.
 * Set all the required parameters when creating an instance of this class.
 * 
 * @author Suhas K
 */
public class PaytmRefund 
{

	public String mTransactionId, mOrderId, mRefundAmount, mTransactioType, mComments, mChecksumHash, mMerchantId;

	/**
	 * Set all the required parameters when creating an instance of this class.
	 * @param inTransactionId This is an unique Paytm transaction Id that is issued by Paytm for each valid transaction request received from the merchant.
	 * @param inOrderId This is the application transaction Id that was sent by merchant to Paytm at the time of transaction request.
	 * @param inRefundAmount Amount to be refunded.
	 * @param inTransactioType Either REFUND or CANCEL.
	 * @param inComments Any comments can be given here.
	 * @param inChecksumHash Checksum calculated based on some logic. It is optional as per merchants configuration.
	 * @param inMerchantId Unique ID which is issued to the Merchant.
	 */
	public PaytmRefund(String inTransactionId, String inOrderId, String inRefundAmount, String inTransactioType, String inComments, String inChecksumHash, String inMerchantId) 
	{
		mTransactionId = inTransactionId;
		mOrderId = inOrderId;
		mRefundAmount = inRefundAmount;
		mTransactioType = inTransactioType;
		mComments = inComments;
		mChecksumHash = inChecksumHash;
		mMerchantId = inMerchantId;
	}
	
}
