package com.paytm.pgsdk;

import android.os.Bundle;

/**
 * This interface contains callback methods of Payment Transaction operation back to Merchant Application.
 * 
 * @author Suhas K
 */
public interface PaytmPaymentTransactionCallback 
{
	
	/**
	 * Payment Transaction successful. 
	 * 
	 * @param inResponse final Merchant Response
	 *//*
	public void onTransactionSuccess(Bundle inResponse);
	
	*//**
	 * Payment Transaction failed.
	 * 
	 * @param inResponse Error Message describing the reason for failure.
	 * @param inResponse final Merchant Response
	 *//*
	public void onTransactionFailure(String inErrorMessage, Bundle inResponse);*/

	public void onTransactionResponse(Bundle inResponse);
	
	/**
	 * Network is not available.
	 */
	public void networkNotAvailable();
	
	/**
	 * Client Authentication is failed.
	 * 
	 * @param inErrorMessage Error Message describing reason for failure of client authentication.
	 */
	public void clientAuthenticationFailed(String inErrorMessage);
	
	/**
	 * Some UI Error Occurred in Payment Gateway Activity.
	 * 
	 * @param inErrorMessage Error Message describing reason for failure.
	 */
	public void someUIErrorOccurred(String inErrorMessage);
	
	/**
	 * Error occurred while loading some page in WebView.
	 * 
	 * @param iniErrorCode ErrorCode
	 * @param inErrorMessage Error Message describing reason for failure.
	 * @param inFailingUrl The url that failed to load. 
	 */
	public void onErrorLoadingWebPage(int iniErrorCode, String inErrorMessage, String inFailingUrl);

	public void onBackPressedCancelTransaction();

	public void onTransactionCancel(String inErrorMessage, Bundle inResponse);
}
