//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.paytm.pgsdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;

import java.util.Iterator;
import java.util.Map.Entry;

public class PaytmPGService {
    private static volatile PaytmPGService mService;
    public volatile PaytmOrder mOrder;
    /*public volatile PaytmMerchant mMerchant;*/
    public volatile PaytmClientCertificate mCertificate;
    private volatile boolean mbServiceRunning;
    private volatile String mStatusQueryURL;
    //protected volatile String mCASURL;
    protected volatile String mCancelTransactionURL;
    protected volatile String mPGURL;
    private static final String STAGING_STATUS_QUERY_URL = "https://pguat.paytm.com/oltp/HANDLER_INTERNAL/TXNSTATUS";
    private static final String PRODUCTION_STATUS_QUERY_URL = "https://secure.paytm.in/oltp/HANDLER_INTERNAL/TXNSTATUS";
    private static final String STAGING_CAS_URL = "https://pguat.paytm.com:8448/CAS/ChecksumGenerator";
    private static final String PRODUCTION_CAS_URL = "https://secure.paytm.in/oltp-web/generateChecksum";
    private static final String STAGING_CANCEL_TRANSACTION_URL = "https://pguat.paytm.com/oltp/HANDLER_INTERNAL/CANCEL_TXN";
    private static final String PRODUCTION_CANCEL_TRANSACTION_URL = "https://secure.paytm.in/oltp/HANDLER_INTERNAL/CANCEL_TXN";
    private static final String STAGING_PG_URL = "https://pguat.paytm.com/oltp-web/processTransaction";
    private static final String PRODUCTION_PG_URL = "https://secure.paytm.in/oltp-web/processTransaction";
    private volatile PaytmPaymentTransactionCallback mPaymentTransactionCallback;
    protected volatile PaytmRefundCallback mRefundCallback;
    protected volatile PaytmStatusQueryCallback mStatusQueryCallback;

    public PaytmPGService() {
    }

    protected static synchronized PaytmPGService getService() {
        try {
            if(mService == null) {
                PaytmUtility.debugLog("Creating an instance of Paytm PG Service...");
                mService = new PaytmPGService();
                PaytmUtility.debugLog("Created a new instance of Paytm PG Service.");
            }
        } catch (Exception var1) {
            PaytmUtility.printStackTrace(var1);
        }

        return mService;
    }

    public static synchronized PaytmPGService getStagingService() {
        PaytmPGService PGService = getService();
        PGService.mStatusQueryURL = "https://pguat.paytm.com/oltp/HANDLER_INTERNAL/TXNSTATUS";
        //PGService.mCASURL = "https://pguat.paytm.com:8448/CAS/ChecksumGenerator";
        PGService.mCancelTransactionURL = "https://securegw-stage.paytm.in/theia/closeOrder";
        PGService.mPGURL = "https://securegw-stage.paytm.in/theia/processTransaction";
        SaveReferences.getInstance().setProduction(false);
        return PGService;
    }


    public static synchronized PaytmPGService getProductionService() {
        PaytmPGService PGService = getService();
        PGService.mStatusQueryURL = "https://secure.paytm.in/oltp/HANDLER_INTERNAL/TXNSTATUS";
        //PGService.mCASURL = "https://secure.paytm.in/oltp-web/generateChecksum";
        PGService.mCancelTransactionURL = "https://securegw.paytm.in/theia/closeOrder";
        PGService.mPGURL = "https://securegw.paytm.in/theia/processTransaction";
        SaveReferences.getInstance().setProduction(true);
        return PGService;
    }

    public synchronized void initialize(PaytmOrder inOrder, PaytmClientCertificate inCertificate) {
        this.mOrder = inOrder;
        //this.mMerchant = inMerchant;
        this.mCertificate = inCertificate;
    }

    /**
     * this function will automatically enable and disable log according to build config
     * @param ctx instance of application class
     */
    public void enableLog(Context ctx) {
        ApplicationInfo appInfoo=getApplicationinfo(ctx);
        if(appInfoo!=null){
            boolean isDebuggable =  ( 0 != (appInfoo.flags &= ApplicationInfo.FLAG_DEBUGGABLE ) );
            Log.setEnableDebugLog(isDebuggable);
        }else{
            Log.setEnableDebugLog(false);
        }

    }

    public synchronized void startPaymentTransaction(Context inCtxt, boolean inbHideHeader, boolean inbSendAllChecksumResponseParametersToPGServer, PaytmPaymentTransactionCallback inPaymentTransactionCallback) {
        try {
            enableLog(inCtxt);
            if(PaytmUtility.isNetworkAvailable(inCtxt)) {
                if (mOrder != null && (mOrder.getRequestParamMap() == null || mOrder.getRequestParamMap().size() <= 0)) {
                    inPaymentTransactionCallback.onTransactionCancel("Invalid Params passed", null);
                    return;
                }
                if(!this.mbServiceRunning) {
                    Bundle inEx = new Bundle();
                    if(this.mOrder != null) {
                        Iterator var7 = this.mOrder.getRequestParamMap().entrySet().iterator();

                        while(var7.hasNext()) {
                            Entry PG = (Entry)var7.next();
                            String paramName = (String)PG.getKey();
                            String paramValue = (String)PG.getValue();
                            PaytmUtility.debugLog(paramName + " = " + paramValue);
                            inEx.putString((String)PG.getKey(), (String)PG.getValue());
                        }
                    }

                    /*if(this.mMerchant != null && this.mMerchant.mChecksumGenerationURL != null && this.mMerchant.mChecksumGenerationURL.length() > 0) {
                        this.mCASURL = this.mMerchant.mChecksumGenerationURL;
                    }*/

                    PaytmUtility.debugLog("Starting the Service...");
                    Intent PG1 = new Intent(inCtxt, PaytmPGActivity.class);
                    PG1.putExtra("Parameters", inEx);
                    PG1.putExtra("HIDE_HEADER", inbHideHeader);
                    PG1.putExtra("SEND_ALL_CHECKSUM_RESPONSE_PARAMETERS_TO_PG_SERVER", inbSendAllChecksumResponseParametersToPGServer);
                    this.mbServiceRunning = true;
                    this.mPaymentTransactionCallback = inPaymentTransactionCallback;
                    SaveReferences.getInstance().setPaytmPaymentTransactionCallback(inPaymentTransactionCallback);
                    ((Activity)inCtxt).startActivity(PG1);
                    PaytmUtility.debugLog("Service Started.");
                } else {
                    PaytmUtility.debugLog("Service is already running.");
                }
            } else {
                this.stopService();
                inPaymentTransactionCallback.networkNotAvailable();
            }
        } catch (Exception var10) {
            this.stopService();
            PaytmUtility.printStackTrace(var10);
        }

    }

    protected synchronized void stopService() {
        mService = null;
        PaytmUtility.debugLog("Service Stopped.");
    }

    /*public synchronized void queryStatus(Context inCtxt, PaytmStatusQuery inStatusQuery, PaytmClientCertificate inCertificate, PaytmStatusQueryCallback inStatusQueryCallback) {
        try {
            Bundle inEx = new Bundle();
            if(inStatusQuery != null) {
                inEx.putString("ORDER_ID", inStatusQuery.mOrderId);
                inEx.putString("MID", inStatusQuery.mMerchantId);
            }

            this.mCertificate = inCertificate;
            PaytmPGService.StatusQueryThread StatusQuery = new PaytmPGService.StatusQueryThread(inCtxt, inEx, inStatusQueryCallback);
            StatusQuery.start();
        } catch (Exception var7) {
            getService().stopService();
            PaytmUtility.printStackTrace(var7);
        }

    }

    public synchronized void cancelTransaction(Context inCtxt, PaytmCancel inCancel, PaytmClientCertificate inCertificate, PaytmCancelTransaction inCancellationHandler) {
        try {
            Bundle inEx = new Bundle();
            if(inCancel != null) {
                inEx = new Bundle();
                inEx.putString("MID", inCancel.mMerchantId);
                inEx.putString("ORDER_ID", inCancel.mOrderId);
            }

            this.mCertificate = inCertificate;
            PaytmPGService.CancelTransactionThread CancelTransaction = new PaytmPGService.CancelTransactionThread(inCtxt, inEx, inCancellationHandler);
            CancelTransaction.start();
        } catch (Exception var7) {
            getService().stopService();
            PaytmUtility.printStackTrace(var7);
        }

    }

    private class CancelTransactionThread extends Thread {
        private Context mCtxt;
        private String mParams;
        private PaytmCancelTransaction mCancellationHandler;
        private static final String JSON_DATA = "JsonData=";
        private static final String OK = "OK";

        public CancelTransactionThread(Context inCtxt, Bundle inParams, PaytmCancelTransaction inCancellationHandler) {
            this.mCtxt = inCtxt;
            this.mParams = "JsonData=" + PaytmUtility.getJSONString(inParams);
            PaytmUtility.debugLog("Params is " + this.mParams);
            this.mCancellationHandler = inCancellationHandler;
        }

        public synchronized void run() {
            String Response = "";

            try {
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier() {
                    public synchronized boolean verify(String hostname, SSLSession session) {
                        PaytmUtility.debugLog("verifying the hostname");
                        return true;
                    }
                });
                URL inEx = new URL(PaytmPGService.this.mCancelTransactionURL);
                PaytmUtility.debugLog("URL is " + inEx.toString());
                URLConnection UrlConnection = inEx.openConnection();
                PaytmUtility.debugLog("New Connection is created.");
                if(URLUtil.isHttpsUrl(inEx.toString())) {
                    PaytmUtility.debugLog("Https url");
                    PaytmUtility.debugLog("Setting SSLSocketFactory to connection...");
                    ((HttpsURLConnection)UrlConnection).setSSLSocketFactory(new PaytmSSLSocketFactory(this.mCtxt, PaytmPGService.this.mCertificate));
                    PaytmUtility.debugLog("SSLSocketFactory is set to connection.");
                }

                UrlConnection.setDoOutput(true);
                ((HttpURLConnection)UrlConnection).setRequestMethod("POST");
                if(this.mParams != null && this.mParams.length() > 0) {
                    PaytmUtility.debugLog("Getting the output stream to post");
                    PrintWriter Out = new PrintWriter(UrlConnection.getOutputStream());
                    PaytmUtility.debugLog("posting......");
                    Out.print(this.mParams);
                    Out.close();
                    PaytmUtility.debugLog("posted parameters and closing output stream");
                    int iResponseCode = ((HttpURLConnection)UrlConnection).getResponseCode();
                    String ResponseMessage = ((HttpURLConnection)UrlConnection).getResponseMessage();
                    PaytmUtility.debugLog("Response code is " + iResponseCode);
                    PaytmUtility.debugLog("Response Message is " + ResponseMessage);
                    if(iResponseCode == 200) {
                        PaytmUtility.debugLog("Getting the input stream to read response");
                        Scanner InStream = new Scanner(UrlConnection.getInputStream());
                        PaytmUtility.debugLog("reading......");

                        while(InStream.hasNextLine()) {
                            Response = Response + InStream.nextLine();
                        }

                        InStream.close();
                        PaytmUtility.debugLog("read response and closing input stream");
                    }
                }

                if(this.mCancellationHandler != null) {
                    PaytmUtility.debugLog("Response is " + Response);
                    if(Response != null && Response.length() > 0 & Response.equalsIgnoreCase("OK")) {
                        this.mCancellationHandler.onCancellationSuccess();
                    } else {
                        this.mCancellationHandler.onCancellationFailure();
                    }
                }
            } catch (Exception var8) {
                if(this.mCancellationHandler != null) {
                    this.mCancellationHandler.onCancellationFailure();
                }

                PaytmUtility.printStackTrace(var8);
            }

        }
    }

    private class StatusQueryThread extends Thread {
        private Context mCtxt;
        private String mParams;
        private static final String JSON_DATA = "JsonData=";

        public StatusQueryThread(Context inCtxt, Bundle inParams, PaytmStatusQueryCallback inStatusQueryCallback) {
            this.mCtxt = inCtxt;
            this.mParams = "JsonData=" + PaytmUtility.getJSONString(inParams);
            PaytmUtility.debugLog("Params is " + this.mParams);
            PaytmPGService.this.mStatusQueryCallback = inStatusQueryCallback;
        }

        public synchronized void run() {
            String Response = "";

            PaytmStatusQueryCallback StatusQueryCallback;
            try {
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier() {
                    public synchronized boolean verify(String hostname, SSLSession session) {
                        PaytmUtility.debugLog("verifying the hostname");
                        return true;
                    }
                });
                URL inEx = new URL(PaytmPGService.this.mStatusQueryURL);
                PaytmUtility.debugLog("URL is " + inEx.toString());
                URLConnection UrlConnection = inEx.openConnection();
                PaytmUtility.debugLog("New Connection is created.");
                if(URLUtil.isHttpsUrl(inEx.toString())) {
                    PaytmUtility.debugLog("Https url");
                    PaytmUtility.debugLog("Setting SSLSocketFactory to connection...");
                    ((HttpsURLConnection)UrlConnection).setSSLSocketFactory(new PaytmSSLSocketFactory(this.mCtxt, PaytmPGService.this.mCertificate));
                    PaytmUtility.debugLog("SSLSocketFactory is set to connection.");
                }

                UrlConnection.setDoOutput(true);
                ((HttpURLConnection)UrlConnection).setRequestMethod("POST");
                if(this.mParams != null && this.mParams.length() > 0) {
                    PaytmUtility.debugLog("Getting the output stream to post");
                    PrintWriter StatusQueryCallback1 = new PrintWriter(UrlConnection.getOutputStream());
                    PaytmUtility.debugLog("posting......");
                    StatusQueryCallback1.print(this.mParams);
                    StatusQueryCallback1.close();
                    PaytmUtility.debugLog("posted parameters and closing output stream");
                    int iResponseCode = ((HttpURLConnection)UrlConnection).getResponseCode();
                    String ResponseMessage = ((HttpURLConnection)UrlConnection).getResponseMessage();
                    PaytmUtility.debugLog("Response code is " + iResponseCode);
                    PaytmUtility.debugLog("Response Message is " + ResponseMessage);
                    if(iResponseCode == 200) {
                        PaytmUtility.debugLog("Getting the input stream to read response");
                        Scanner InStream = new Scanner(UrlConnection.getInputStream());
                        PaytmUtility.debugLog("reading......");

                        while(InStream.hasNextLine()) {
                            Response = Response + InStream.nextLine();
                        }

                        InStream.close();
                        PaytmUtility.debugLog("read response and closing input stream");
                    }
                }

                PaytmUtility.debugLog("Response is " + Response);
                if(Response != null && Response.length() > 0) {
                    StatusQueryCallback = PaytmPGService.getService().mStatusQueryCallback;
                    if(StatusQueryCallback != null) {
                        StatusQueryCallback.onStatusQueryCompleted((Bundle)null);
                    }
                } else {
                    StatusQueryCallback = PaytmPGService.getService().mStatusQueryCallback;
                    if(StatusQueryCallback != null) {
                        StatusQueryCallback.onStatusQueryFailed("");
                    }
                }

                PaytmPGService.getService().stopService();
            } catch (Exception var8) {
                StatusQueryCallback = PaytmPGService.getService().mStatusQueryCallback;
                if(StatusQueryCallback != null) {
                    StatusQueryCallback.onStatusQueryFailed("");
                }

                PaytmPGService.getService().stopService();
                PaytmUtility.printStackTrace(var8);
            }

        }
    }*/

    /**
     * this function will return Application info if it does not get package name will retur null
     * @param ctx context
     * @return ApplicationInfo object of current class
     */
    private ApplicationInfo getApplicationinfo(Context ctx) {
        ApplicationInfo app=null ;
        try {
            PackageManager manager=ctx.getPackageManager();
             app = manager.getApplicationInfo(ctx.getPackageName(), 0);
        }catch (PackageManager.NameNotFoundException e){
            //it should never come
            e.printStackTrace();

        }
        return app;
    }

    public PaytmPaymentTransactionCallback getmPaymentTransactionCallback() {
        if(mPaymentTransactionCallback == null){
            return SaveReferences.getInstance().getPaytmPaymentTransactionCallback();
        }
        return mPaymentTransactionCallback;
    }
}
