package com.paytm.pgsdk;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.webkit.URLUtil;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import org.apache.http.client.methods.HttpPost;
import org.json.JSONObject;

import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Scanner;

import javax.net.ssl.HttpsURLConnection;

/**
 * This Activity will show the UI of Paytm PG Service. It contains UI to show
 * Progress of Transactions and webpages in webview.
 *
 * @author Suhas K
 */
public class PaytmPGActivity extends Activity {

    // Progress Bar
    protected volatile ProgressBar mProgress;

    // WebView
    private volatile PaytmWebView mWV;

    // Client Authenticator Task.
    private volatile AuthenticatorTask mAuthenticator;

    // Parameters to be posted to PG Server.
    private volatile Bundle mParams;

    /**
     * Key name to retrieve CheckSum from CAS Response.
     */
    private static final String CHECKSUMHASH = "CHECKSUMHASH";

    /**
     * Client authentication failed Message.
     */
    private static final String CLIENT_AUTHENTICATION_FAILED = "Client authentication failed. Please try again later.";

    /**
     * Client authentication failed Message.
     */
    private static final String CLIENT_AUTHENTICATION_FAILED_DUE_TO_SERVER_ERROR = "Client authentication failed due to server error. Please try again later.";

    /**
     * UI initialization error occurred Message.
     */
    private static final String UI_INITIALIZATION_ERROR_OCCURED = "Some error occured while initializing UI of Payment Gateway Activity";

    /**
     * Some UI error occurred Message.
     */
    private static final String UI_WEBVIEW_ERROR_OCCURED = "Some UI error occured in WebView of Payment Gateway Activity";

    /**
     * Paytm Client Authentication Status.
     */
    private static final String PAYT_STATUS = "payt_STATUS";

    /**
     * Client authentication Success.
     */
    private static final String SUCCESS = "1";

    /**
     * Transaction Cancelled.
     */
    private static final String TRANSACTION_CANCELLED = "Transaction Cancelled.";

    /**
     * Transaction not Cancelled.
     */
    private static final String TRANSACTION_NOT_CANCELLED = "Transaction not Cancelled.";

    /**
     * Transaction cancelled by the User Message
     */
    private static final String USER_CANCELED_TRANSACTION = "Transaction cancelled by user.";

    private Dialog mDlg;

    private boolean mbIsCancellingRequest;

    private boolean mbChecksumGenerated;

    private boolean mbHideHeader;

    private String paramsString, urlString;

    private boolean mbSendAllChecksumResponseParametersToPGServer;


    protected void onRestore(Bundle savedInstanceState) {
        if (SaveReferences.getInstance().isProduction()) {
            PaytmPGService.getProductionService();
        } else {
            PaytmPGService.getStagingService();
        }
        PaytmUtility.debugLog("Came in onRestoreInstanceState");
        mbHideHeader = savedInstanceState.getBoolean(PaytmConstants.HIDE_HEADER);
        mbSendAllChecksumResponseParametersToPGServer = savedInstanceState.getBoolean(PaytmConstants.SEND_ALL_CHECKSUM_RESPONSE_PARAMETERS_TO_PG_SERVER);
        mParams = savedInstanceState.getBundle(PaytmConstants.PARAMETERS);
        paramsString = savedInstanceState.getString(PaytmConstants.PARAMETERS_STRING);
        urlString = savedInstanceState.getString(PaytmConstants.URL_STRING);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        PaytmUtility.debugLog("Came in onSaveInstanceState");
        outState.putBoolean(PaytmConstants.HIDE_HEADER, mbHideHeader);
        outState.putBoolean(PaytmConstants.SEND_ALL_CHECKSUM_RESPONSE_PARAMETERS_TO_PG_SERVER, mbSendAllChecksumResponseParametersToPGServer);
        outState.putBundle(PaytmConstants.PARAMETERS, mParams);
        outState.putString(PaytmConstants.PARAMETERS_STRING, paramsString);
        outState.putString(PaytmConstants.URL_STRING, urlString);
    }

    @Override
    protected synchronized void onCreate(Bundle inSavedInstanceState) {
        super.onCreate(inSavedInstanceState);
        if (inSavedInstanceState != null) {
            onRestore(inSavedInstanceState);
        }
        if (initUI())
            startTransaction();
        else {
            finish();
            PaytmPaymentTransactionCallback PaymentTransactionCallback = PaytmPGService.getService().getmPaymentTransactionCallback();
            if (PaymentTransactionCallback != null)
                PaymentTransactionCallback.someUIErrorOccurred(UI_INITIALIZATION_ERROR_OCCURED);
        }
    }

    /**
     * This method will make UI initialization.
     */
    private synchronized boolean initUI() {
        try {
            if (getIntent() != null) {
                mbHideHeader = getIntent().getBooleanExtra(PaytmConstants.HIDE_HEADER, false);
                mbSendAllChecksumResponseParametersToPGServer = getIntent().getBooleanExtra(PaytmConstants.SEND_ALL_CHECKSUM_RESPONSE_PARAMETERS_TO_PG_SERVER, false);
            }
            PaytmUtility.debugLog("Hide Header " + mbHideHeader);
            PaytmUtility.debugLog("Initializing the UI of Transaction Page...");

            RelativeLayout RootView = new RelativeLayout(this);

            RelativeLayout TopBar = new RelativeLayout(this);
            RelativeLayout.LayoutParams TopBarParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
            TopBar.setLayoutParams(TopBarParams);
            TopBar.setId(1);
            TopBar.setBackgroundColor(Color.parseColor("#bdbdbd"));

            Button Cancel = new Button(this, null, android.R.attr.buttonStyleSmall);
            RelativeLayout.LayoutParams CancelParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
            CancelParams.addRule(RelativeLayout.CENTER_VERTICAL);
            CancelParams.leftMargin = (int) (getResources().getDisplayMetrics().density * 5);
            Cancel.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View v) {
                    PaytmUtility.debugLog("User pressed back button which is present in Header Bar.");
                    cancelTransaction();
                }
            });
            Cancel.setLayoutParams(CancelParams);
            Cancel.setText("Cancel");

            TextView AppName = new TextView(this);
            RelativeLayout.LayoutParams AppNameParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
            AppNameParams.addRule(RelativeLayout.CENTER_IN_PARENT);
            AppName.setLayoutParams(AppNameParams);
            AppName.setTextColor(Color.BLACK);
            AppName.setText("Paytm Payments");

            TopBar.addView(Cancel);
            TopBar.addView(AppName);

            RelativeLayout WebLayout = new RelativeLayout(this);
            RelativeLayout.LayoutParams WebLayoutParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
            WebLayoutParams.addRule(RelativeLayout.BELOW, TopBar.getId());
            WebLayout.setLayoutParams(WebLayoutParams);

            mWV = new PaytmWebView(PaytmPGActivity.this, mParams);
            mWV.setVisibility(View.GONE);
            RelativeLayout.LayoutParams WebParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
            mWV.setLayoutParams(WebParams);

            mProgress = new ProgressBar(this, null, android.R.attr.progressBarStyleSmall);
            RelativeLayout.LayoutParams ProgressParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
            ProgressParams.addRule(RelativeLayout.CENTER_IN_PARENT);
            mProgress.setLayoutParams(ProgressParams);

            WebLayout.addView(mWV);
            WebLayout.addView(mProgress);

            RootView.addView(TopBar);
            RootView.addView(WebLayout);

            if (mbHideHeader)
                TopBar.setVisibility(View.GONE);
            this.requestWindowFeature(Window.FEATURE_NO_TITLE);
            setContentView(RootView);
            PaytmUtility.debugLog("Initialized UI of Transaction Page.");
            return true;
        } catch (Exception inEx) {
            PaytmUtility.debugLog("Some exception occurred while initializing UI.");
            PaytmUtility.printStackTrace(inEx);
            return false;
        }
    }

    @Override
    protected synchronized void onDestroy() {
        super.onDestroy();
        try {
            // Cancel, if any ongoing Authentication Task
            if (mAuthenticator != null)
                mAuthenticator.cancel(true);
            PaytmPGService.getService().stopService();
        } catch (Exception inEx) {
            PaytmPGService.getService().stopService();
            PaytmUtility.debugLog("Some exception occurred while destroying the PaytmPGActivity.");
            PaytmUtility.printStackTrace(inEx);
        }
    }

    /**
     * This is the Client Authentication task. After obtaining connection some
     * data will be posted to CAS Server. If Client is authenticated
     * successfully, Transaction will be continued otherwise Error will be
     * returned.
     *
     * @author Suhas K
     */
    private class AuthenticatorTask extends AsyncTask<String, Void, String> {
        @Override
        protected synchronized String doInBackground(String... inURL) {
            String Response = PaytmConstants.EMPTY;
            URLConnection UrlConnection = null;
            try {
                /*HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier() {
					@Override
					public boolean verify(String hostname, SSLSession session) {
						PaytmUtility.debugLog("verifying the hostname");
						return true;
					}
				});*/

                URL Url = new URL(inURL[0]);
                PaytmUtility.debugLog("URL is " + Url.toString());
                UrlConnection = Url.openConnection();
                PaytmUtility.debugLog("New Connection is created.");
                if (URLUtil.isHttpsUrl(Url.toString())) {
                    PaytmUtility.debugLog("Https url");
                    PaytmUtility.debugLog("Setting SSLSocketFactory to connection...");
                    ((HttpsURLConnection) UrlConnection).setSSLSocketFactory(new PaytmSSLSocketFactory(PaytmPGActivity.this, PaytmPGService.getService().mCertificate));
                    PaytmUtility.debugLog("SSLSocketFactory is set to connection.");
                }
                UrlConnection.setDoOutput(true);
                ((HttpURLConnection) UrlConnection).setRequestMethod(HttpPost.METHOD_NAME);
                String Params = PaytmUtility.getStringFromBundle(mParams);

                if (Params != null && Params.length() > 0) {
                    PaytmUtility.debugLog("Getting the output stream to post");
                    PrintWriter Out = new PrintWriter(UrlConnection.getOutputStream());
                    PaytmUtility.debugLog("posting......");
                    Out.print(Params);
                    Out.close();
                    PaytmUtility.debugLog("posted parameters and closing output stream");
                    int iResponseCode = ((HttpURLConnection) UrlConnection).getResponseCode();
                    String ResponseMessage = ((HttpURLConnection) UrlConnection).getResponseMessage();
                    PaytmUtility.debugLog("Response code is " + iResponseCode);
                    PaytmUtility.debugLog("Response Message is " + ResponseMessage);
                    if (iResponseCode == HttpsURLConnection.HTTP_OK) {
                        PaytmUtility.debugLog("Getting the input stream to read response");
                        Scanner InStream = new Scanner(UrlConnection.getInputStream());
                        PaytmUtility.debugLog("reading......");
                        while (InStream.hasNextLine())
                            Response += (InStream.nextLine());
                        InStream.close();
                        PaytmUtility.debugLog("read response and closing input stream");
                    }
                }
            } catch (Exception inEx) {
                PaytmUtility.debugLog("Some exception occurred while making client authentication.");
                PaytmUtility.printStackTrace(inEx);
            }
            try {
                if (UrlConnection != null)
                    ((HttpURLConnection) UrlConnection).disconnect();
                PaytmUtility.debugLog("connection is disconnected");
            } catch (Exception inEx) {
                PaytmUtility.printStackTrace(inEx);
            }
            return Response;
        }

        @Override
        protected synchronized void onPostExecute(String inResult) {
            try {
                if (inResult != null && !inResult.equalsIgnoreCase(PaytmConstants.EMPTY)) {
                    PaytmUtility.debugLog("Response is " + inResult);
                    // If Verification Status in Response is Success then start
                    // webview and post to PG Server else
                    // finsh this activity.
                    boolean bSuccess = extractJSON(inResult);
                    if (bSuccess) {
                        mbChecksumGenerated = true;
                        mWV.setVisibility(View.VISIBLE);
                        mWV.postUrl(PaytmPGService.getService().mPGURL, PaytmUtility.getURLEncodedStringFromBundle(mParams).getBytes());
                        mWV.requestFocus(View.FOCUS_DOWN);
                    } else {
                        finish();
                        PaytmPaymentTransactionCallback PaymentTransactionCallback = PaytmPGService.getService().getmPaymentTransactionCallback();
                        if (PaymentTransactionCallback != null)
                            PaymentTransactionCallback.clientAuthenticationFailed(CLIENT_AUTHENTICATION_FAILED);
                    }
                } else {
                    finish();
                    PaytmPaymentTransactionCallback PaymentTransactionCallback = PaytmPGService.getService().getmPaymentTransactionCallback();
                    if (PaymentTransactionCallback != null)
                        PaymentTransactionCallback.clientAuthenticationFailed(CLIENT_AUTHENTICATION_FAILED_DUE_TO_SERVER_ERROR);
                }

            } catch (Exception inEx) {
                finish();
                PaytmPaymentTransactionCallback PaymentTransactionCallback = PaytmPGService.getService().getmPaymentTransactionCallback();
                if (PaymentTransactionCallback != null)
                    PaymentTransactionCallback.someUIErrorOccurred(UI_WEBVIEW_ERROR_OCCURED);
                PaytmUtility.debugLog("Some exception occurred while posting data to PG Server.");
                PaytmUtility.printStackTrace(inEx);
            }
        }
    }

    /**
     * This method will parse the JSON and extract the Client Verification
     * Status and CheckSum.
     *
     * @param inResult Response got from CAS Server, which is in JSON Format.
     * @return boolean value.
     */
    private synchronized boolean extractJSON(String inResult) {
        boolean bSuccess = false;
        try {
            PaytmUtility.debugLog("Parsing JSON");
            JSONObject Obj = new JSONObject(inResult);
            Iterator<String> Keys = Obj.keys();
            PaytmUtility.debugLog("Appending Key Value pairs");
            PaytmUtility.debugLog("Send All Checksum Response Parameters to PG " + mbSendAllChecksumResponseParametersToPGServer);
            while (Keys.hasNext()) {
                String Key = Keys.next();
                String Value = Obj.getString(Key);
                Key = Key.trim();
                PaytmUtility.debugLog(Key + " = " + Value);
                if (Key.equals(CHECKSUMHASH))
                    mParams.putString(Key, Value);
                else if (mbSendAllChecksumResponseParametersToPGServer)
                    mParams.putString(Key, Value);

                if (Key.equals(PAYT_STATUS) && Value.equals(SUCCESS))
                    bSuccess = true;
            }
        } catch (Exception inEx) {
            PaytmUtility.debugLog("Some exception occurred while extracting the checksum from CAS Response.");
            PaytmUtility.printStackTrace(inEx);
        }
        return bSuccess;
    }

    /**
     * This method will extract the Bundle coming along with the intent and will
     * start Client Authentication task.
     */
    private synchronized void startTransaction() {
        PaytmUtility.debugLog("Starting the Process...");
        if (getIntent() != null && getIntent().getBundleExtra(PaytmConstants.PARAMETERS) != null) {
            mParams = getIntent().getBundleExtra(PaytmConstants.PARAMETERS);
            if (mParams != null && mParams.size() > 0) {
                PaytmUtility.debugLog("Starting the Client Authentication...");
                mAuthenticator = new AuthenticatorTask();
                if (PaytmPGService.getService() != null) {
                    //mAuthenticator.execute(new String[] { PaytmPGService.getService().mCASURL });
                    mWV.setVisibility(View.VISIBLE);
                    mWV.postUrl(PaytmPGService.getService().mPGURL, PaytmUtility.getURLEncodedStringFromBundle(mParams).getBytes());
                    mWV.requestFocus(View.FOCUS_DOWN);

                    if (PaytmPGService.getService().mOrder.getRequestParamMap().get("prenotificationurl") != null) {
                        Intent intent = new Intent(getApplicationContext(),IntentServicePreNotification.class);
                        intent.putExtra("url",PaytmPGService.getService().mOrder.getRequestParamMap().get("prenotificationurl"));
                        getApplicationContext().startService(intent);
                    }

                }
            }
        }
    }

    @Override
    public synchronized boolean onKeyDown(int keyCode, KeyEvent event) {
        PaytmUtility.debugLog("User pressed key and key code is " + keyCode);
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            PaytmUtility.debugLog("User pressed hard key back button");
            // If user pressed back button, then call cancelTransaction().
            // Check whether CheckSum Generation is successful.
            cancelTransaction();
        }
        return super.onKeyDown(keyCode, event);
    }

    /**
     * This method will display toast notification.
     *
     * @param inMsg Message to be displayed.
     */
    private synchronized void displayToastNotification(final String inMsg) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    mbIsCancellingRequest = false;
                    PaytmUtility.debugLog(inMsg);
                    Toast.makeText(PaytmPGActivity.this, inMsg, Toast.LENGTH_SHORT).show();
                    PaytmUtility.debugLog("User cancelled " + mParams);
                    PaytmPGService.getService().getmPaymentTransactionCallback().onTransactionCancel(USER_CANCELED_TRANSACTION, mParams);
                    PaytmUtility.debugLog("user cancellation");
                    finish();
                } catch (Exception inEx) {
                    inEx.printStackTrace();
                }
            }
        });
    }

    private synchronized void cancelTransaction() {
        if (!mbIsCancellingRequest) {
            PaytmUtility.debugLog("Displaying Confirmation Dialog");
            AlertDialog.Builder DlgBuilder = null;
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.HONEYCOMB) {
                DlgBuilder = new AlertDialog.Builder(PaytmPGActivity.this,android.R.style.Theme_Material_Dialog_Alert);
            }else{
                DlgBuilder = new AlertDialog.Builder(PaytmPGActivity.this);
            }
            DlgBuilder.setTitle("Cancel Transaction");
            DlgBuilder.setMessage("Are you sure you want to cancel transaction");
            DlgBuilder.setPositiveButton("Yes", new AlertDialog.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    PaytmPGActivity.this.onBackPressed();
					/*try {
						mbIsCancellingRequest = true;
						if (mbChecksumGenerated) {
							PaytmUtility.debugLog("Checksum is generated.");
							mProgress.setVisibility(View.VISIBLE);

							String mId =
									PaytmPGService.getService().mOrder.getRequestParamMap
											().get("MID");
							String orderId =
									PaytmPGService.getService(
									).mOrder.getRequestParamMap().get("ORDER_ID");

							//PaytmCancel Cancel = new
							PaytmCancel(PaytmPGService.getService
											().mMerchant.mMerchantIdentifier,
									PaytmPGService.getService().mOrder.mOrderId);
							PaytmCancel
									Cancel = new PaytmCancel(mId, orderId);
							PaytmPGService.getService
									().cancelTransaction(PaytmPGActivity.this, Cancel,
									PaytmPGService.getService().mCertificate, new
											PaytmCancelTransaction() {

												@Override
												public void onCancellationSuccess() {
													displayToastNotification(TRANSACTION_CANCELLED);
												}

												@Override
												public void onCancellationFailure() {
													displayToastNotification(TRANSACTION_NOT_CANCELLED);
												}
											});
						} else {
							PaytmUtility.debugLog("Checksum is not generated.");
							displayToastNotification(TRANSACTION_CANCELLED);
						}
						mDlg.dismiss();
					} catch (Exception inEx) {
						PaytmUtility.printStackTrace(inEx);
					}*/
                }
            });
            DlgBuilder.setNegativeButton("No", new AlertDialog.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    mDlg.dismiss();
                }
            });

            mDlg = DlgBuilder.create();
            mDlg.show();
        }

    }

    @Override
    public void onBackPressed() {
        PaytmPGService.getService().getmPaymentTransactionCallback().onBackPressedCancelTransaction();
        super.onBackPressed();
    }


}
