package com.paytm.pgsdk;

import java.util.Map;

/**
 * This class contains member variables holding the Order Information.
 * Set all the required parameters when creating an instance of this class.
 * 
 * @author Suhas K
 */
public class PaytmOrder 
{

	private Map<String, String> requestParamMap;

	public PaytmOrder(Map<String, String> requestParamMap) throws IllegalArgumentException {
		if (requestParamMap == null || requestParamMap.size() <= 0) {
			throw new IllegalArgumentException("Invalid request params");
		} else if (!requestParamMap.containsKey("CALLBACK_URL")) {
			throw new IllegalArgumentException("CALLBACK_URL not present");
		} else if (!requestParamMap.containsKey("CHECKSUMHASH")) {
			throw new IllegalArgumentException("CHECKSUMHASH not present");
		} else if (!requestParamMap.containsKey("CUST_ID")) {
			throw new IllegalArgumentException("CUST_ID not present");
		} else if (!requestParamMap.containsKey("INDUSTRY_TYPE_ID")) {
			throw new IllegalArgumentException("INDUSTRY_TYPE_ID not present");
		} else if (!requestParamMap.containsKey("MID")) {
			throw new IllegalArgumentException("MID not present");
		} else if (!requestParamMap.containsKey("ORDER_ID")) {
			throw new IllegalArgumentException("ORDER_ID not present");
		} else if (!requestParamMap.containsKey("WEBSITE")) {
			throw new IllegalArgumentException("WEBSITE not present");
		} else if (!requestParamMap.containsKey("CALLBACK_URL")) {
			throw new IllegalArgumentException("CALLBACK_URL not present");
		} else if (!requestParamMap.containsKey("CHANNEL_ID")) {
			throw new IllegalArgumentException("CHANNEL_ID not present");
		} else if (!requestParamMap.containsKey("TXN_AMOUNT")) {
			throw new IllegalArgumentException("TXN_AMOUNT not present");
		}
		this.requestParamMap = requestParamMap;
	}
	
	public Map<String, String> getRequestParamMap() {
		
		return this.requestParamMap;
	}
	
}
