package com.paytm.pgsdk;

/**
 * This class contains member variables holding the Merchant Configuration.
 * Set all the required parameters when creating an instance of this class.
 * 
 * @author Suhas K
 */
public class PaytmMerchant
{

	public String mMerchantIdentifier, mChannelId, mIndustryTypeId, mWebsite, mTheme, mChecksumGenerationURL, mChecksumVerificationURL;
	
	/**
	 * Set all the required parameters when creating an instance of this class.
	 * @param inMerchantIdentifier a unique ID which is issued to the Merchant.
	 * @param inChannelId either WEB, WAP, IVR.
	 * @param inIndustryTypeId Retail.
	 * @param inWebsite website.
	 * @param inTheme javas, iphone, etc.
	 * @param inChecksumGenerationUR Merchant Checksum Generation URL. If it is set to null or empty Default Paytm Checksum Generator URL will be used.
	 * @param inChecksumVerificationURL Merchant Checksum Verification URL. If it is set to null or empty then Checksum will be verified by Paytm Server.
	 */
	public PaytmMerchant(String inMerchantIdentifier, String inChannelId, String inIndustryTypeId, String inWebsite, String inTheme, String inChecksumGenerationUR, String inChecksumVerificationURL) 
	{
		mMerchantIdentifier = inMerchantIdentifier;
		mChannelId = inChannelId;
		mIndustryTypeId = inIndustryTypeId;
		mWebsite = inWebsite;
		mTheme = inTheme;
		mChecksumGenerationURL = inChecksumGenerationUR;
		mChecksumVerificationURL = inChecksumVerificationURL;
	}
	
	
	public PaytmMerchant(String inChecksumGenerationUR, String inChecksumVerificationURL) {
		
		mChecksumGenerationURL = inChecksumGenerationUR;
		mChecksumVerificationURL = inChecksumVerificationURL;
	}
	
}
