package com.paytm.pgsdk;

/**
 * This class contains constants used in the Paytm PG SDK.
 * Constants representing key names are accessible to Merchant application.
 *
 * @author Suhas K
 */
public class PaytmConstants {

    //These following constants are accessible to Merchant application.

    /**
     * Key name for Merchant Id.
     */
    public static final String MERCHANT_ID = "MID";

    /**
     * Key name for Transaction Id.
     */
    public static final String TRANSACTION_ID = "TXNID";

    /**
     * Key name for Bank Transaction Id.
     */
    public static final String BANK_TRANSACTION_ID = "BANKTXNID";

    /**
     * Key name for Status.
     */
    public static final String STATUS = "STATUS";

    /**
     * Key name for Response Code.
     */
    public static final String RESPONSE_CODE = "RESPCODE";

    /**
     * Key name for Response Message.
     */
    public static final String RESPONSE_MSG = "RESPMSG";

    /**
     * Key name for Transaction Date.
     */
    public static final String TRANSACTION_DATE = "TXNDATE";

    /**
     * Key name for Gateway Name.
     */
    public static final String GATEWAY_NAME = "GATEWAYNAME";

    /**
     * Key name for Bank Name.
     */
    public static final String BANK_NAME = "BANKNAME";

    /**
     * Key name for Payment Mode.
     */
    public static final String PAYMENT_MODE = "PAYMENTMODE";

    /**
     * Key Name for Transaction Type.
     */
    public static final String TRANSACTION_TYPE = "TXNTYPE";

    /**
     * Key name for Is Checksum Valid.
     */
    public static final String IS_CHECKSUM_VALID = "IS_CHECKSUM_VALID";

    /**
     * Key name for Checksum.
     */
    public static final String CHECKSUM = "CHECKSUM";

    /**
     * Key name for Order Id.
     */
    public static final String ORDER_ID = "ORDERID";

    /**
     * Key name for txn amount.
     */
    public static final String TRANSACTION_AMOUNT = "TXNAMOUNT";

    /**
     * Key name for refund amount.
     */
    public static final String REFUND_AMOUNT = "REFUNDAMT";


    //These following constants are used inside the PG SDK.

    /**
     * Empty String.
     */
    protected static final String EMPTY = "";

    /**
     * Key Name of Bundle which is containing Parameters to be posted to CAS Server.
     */
    protected static final String PARAMETERS = "Parameters";

    protected static final String HIDE_HEADER = "HIDE_HEADER";

    protected static final String SEND_ALL_CHECKSUM_RESPONSE_PARAMETERS_TO_PG_SERVER = "SEND_ALL_CHECKSUM_RESPONSE_PARAMETERS_TO_PG_SERVER";

    public static final String PARAMETERS_STRING = "Parameters_String";
    public static String URL_STRING = "Url_String";

}
