package com.paytm.pgsdk;

/**
 * This class contains member variables holding the information required for canceling the transaction.
 * Set all the required parameters when creating an instance of this class.
 * 
 * @author Suhas K
 */
public class PaytmCancel 
{
	
	public String mMerchantId, mOrderId;
	
	/**
	 * Set all the required parameters when creating an instance of this class.
	 * @param inMerchantId Unique ID which is issued to the Merchant.
	 * @param inOrderId This is the application transaction Id that was sent by merchant to Paytm at the time of transaction request.
	 */
	public PaytmCancel(String inMerchantId, String inOrderId)
	{
		mMerchantId = inMerchantId;
		mOrderId = inOrderId;
	}
	
}
