package com.paytm.pgsdk;

import android.app.IntentService;
import android.content.Intent;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * An {@link IntentService} subclass for handling asynchronous task requests in
 * a service on a separate handler thread.
 * <p>
 * TODO: Customize class - update intent actions, extra parameters and static
 * helper methods.
 */
public class IntentServicePostNotification extends IntentService {

    public IntentServicePostNotification() {
        super("IntentServicePostNotification");
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        if (intent != null) {
            final String URL = intent.getExtras().getString("url");
            callHttp(URL);
        }
    }

    public void callHttp(String urlCall) {
        URL url;
        HttpURLConnection urlConnection = null;
        try {
            url = new URL(urlCall);

            urlConnection = (HttpURLConnection) url
                    .openConnection();

            InputStream in = urlConnection.getInputStream();

            InputStreamReader isw = new InputStreamReader(in);

            int data = isw.read();
            while (data != -1) {
                char current = (char) data;
                data = isw.read();
                System.out.print(current);
                Log.v("postnotification called response", current + "");
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

}
