/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android.ui.paymentchannels.mobilemoney.mpesa.numberform;

import com.paystack.android.core.api.models.MobileMoneyChannelOption;
import com.paystack.android.ui.utilities.CurrencyFormatter;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 )2\u00020\u0001:\u0001)B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\fH\u00c6\u0003JK\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010$\u001a\u00020\f2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0018R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lcom/paystack/android/ui/paymentchannels/mobilemoney/mpesa/numberform/MpesaNumberFormState;", "", "amount", "", "currency", "", "providers", "", "Lcom/paystack/android/core/api/models/MobileMoneyChannelOption;", "providerKey", "phoneNumber", "isProcessing", "", "(JLjava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Z)V", "getAmount", "()J", "amountText", "getAmountText", "()Ljava/lang/String;", "channelOption", "getChannelOption", "()Lcom/paystack/android/core/api/models/MobileMoneyChannelOption;", "getCurrency", "isPhoneNumberValid", "()Z", "getPhoneNumber", "getProviderKey", "getProviders", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "paystack-ui_release"})
@SourceDebugExtension(value={"SMAP\nMpesaNumberFormState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MpesaNumberFormState.kt\ncom/paystack/android/ui/paymentchannels/mobilemoney/mpesa/numberform/MpesaNumberFormState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n223#2,2:34\n*S KotlinDebug\n*F\n+ 1 MpesaNumberFormState.kt\ncom/paystack/android/ui/paymentchannels/mobilemoney/mpesa/numberform/MpesaNumberFormState\n*L\n17#1:34,2\n*E\n"})
public final class MpesaNumberFormState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long amount;
    @NotNull
    private final String currency;
    @NotNull
    private final List<MobileMoneyChannelOption> providers;
    @NotNull
    private final String providerKey;
    @NotNull
    private final String phoneNumber;
    private final boolean isProcessing;
    @NotNull
    private static final String MPESA_KEY = "MPESA";
    @NotNull
    private static final String KE_PHONE_NUMBER_REGEX = "(\\+254|254|0|^)([7][0-9]|[1][0-1]){1}[0-9]{1}[0-9]{6}";

    public MpesaNumberFormState(long amount, @NotNull String currency, @NotNull List<MobileMoneyChannelOption> providers, @NotNull String providerKey, @NotNull String phoneNumber, boolean isProcessing) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter((Object)providerKey, (String)"providerKey");
        Intrinsics.checkNotNullParameter((Object)phoneNumber, (String)"phoneNumber");
        this.amount = amount;
        this.currency = currency;
        this.providers = providers;
        this.providerKey = providerKey;
        this.phoneNumber = phoneNumber;
        this.isProcessing = isProcessing;
    }

    public /* synthetic */ MpesaNumberFormState(long l, String string2, List list, String string3, String string4, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string4 = "";
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(l, string2, list, string3, string4, bl);
    }

    public final long getAmount() {
        return this.amount;
    }

    @NotNull
    public final String getCurrency() {
        return this.currency;
    }

    @NotNull
    public final List<MobileMoneyChannelOption> getProviders() {
        return this.providers;
    }

    @NotNull
    public final String getProviderKey() {
        return this.providerKey;
    }

    @NotNull
    public final String getPhoneNumber() {
        return this.phoneNumber;
    }

    public final boolean isProcessing() {
        return this.isProcessing;
    }

    @NotNull
    public final String getAmountText() {
        return CurrencyFormatter.format$default(CurrencyFormatter.INSTANCE, this.amount, this.currency, false, false, 12, null);
    }

    private final MobileMoneyChannelOption getChannelOption() {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = this.providers;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MobileMoneyChannelOption it = (MobileMoneyChannelOption)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKey(), (Object)this.providerKey)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return MobileMoneyChannelOption.copy$default((MobileMoneyChannelOption)((MobileMoneyChannelOption)element$iv2), null, null, (boolean)false, (String)(StringsKt.equals((String)this.providerKey, (String)MPESA_KEY, (boolean)true) ? KE_PHONE_NUMBER_REGEX : this.getChannelOption().getPhoneNumberRegex()), (int)7, null);
    }

    public final boolean isPhoneNumberValid() {
        return new Regex(this.getChannelOption().getPhoneNumberRegex()).matches((CharSequence)this.phoneNumber);
    }

    public final long component1() {
        return this.amount;
    }

    @NotNull
    public final String component2() {
        return this.currency;
    }

    @NotNull
    public final List<MobileMoneyChannelOption> component3() {
        return this.providers;
    }

    @NotNull
    public final String component4() {
        return this.providerKey;
    }

    @NotNull
    public final String component5() {
        return this.phoneNumber;
    }

    public final boolean component6() {
        return this.isProcessing;
    }

    @NotNull
    public final MpesaNumberFormState copy(long amount, @NotNull String currency, @NotNull List<MobileMoneyChannelOption> providers, @NotNull String providerKey, @NotNull String phoneNumber, boolean isProcessing) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter((Object)providerKey, (String)"providerKey");
        Intrinsics.checkNotNullParameter((Object)phoneNumber, (String)"phoneNumber");
        return new MpesaNumberFormState(amount, currency, providers, providerKey, phoneNumber, isProcessing);
    }

    public static /* synthetic */ MpesaNumberFormState copy$default(MpesaNumberFormState mpesaNumberFormState, long l, String string2, List list, String string3, String string4, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            l = mpesaNumberFormState.amount;
        }
        if ((n & 2) != 0) {
            string2 = mpesaNumberFormState.currency;
        }
        if ((n & 4) != 0) {
            list = mpesaNumberFormState.providers;
        }
        if ((n & 8) != 0) {
            string3 = mpesaNumberFormState.providerKey;
        }
        if ((n & 0x10) != 0) {
            string4 = mpesaNumberFormState.phoneNumber;
        }
        if ((n & 0x20) != 0) {
            bl = mpesaNumberFormState.isProcessing;
        }
        return mpesaNumberFormState.copy(l, string2, list, string3, string4, bl);
    }

    @NotNull
    public String toString() {
        return "MpesaNumberFormState(amount=" + this.amount + ", currency=" + this.currency + ", providers=" + this.providers + ", providerKey=" + this.providerKey + ", phoneNumber=" + this.phoneNumber + ", isProcessing=" + this.isProcessing + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this.amount);
        result = result * 31 + this.currency.hashCode();
        result = result * 31 + ((Object)this.providers).hashCode();
        result = result * 31 + this.providerKey.hashCode();
        result = result * 31 + this.phoneNumber.hashCode();
        int n = this.isProcessing ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MpesaNumberFormState)) {
            return false;
        }
        MpesaNumberFormState mpesaNumberFormState = (MpesaNumberFormState)other;
        if (this.amount != mpesaNumberFormState.amount) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.currency, (Object)mpesaNumberFormState.currency)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.providers, mpesaNumberFormState.providers)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.providerKey, (Object)mpesaNumberFormState.providerKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.phoneNumber, (Object)mpesaNumberFormState.phoneNumber)) {
            return false;
        }
        return this.isProcessing == mpesaNumberFormState.isProcessing;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/paystack/android/ui/paymentchannels/mobilemoney/mpesa/numberform/MpesaNumberFormState$Companion;", "", "()V", "KE_PHONE_NUMBER_REGEX", "", "MPESA_KEY", "paystack-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

