package com.paystack.android.ui.paymentchannels.card.auth.otp

import android.os.CountDownTimer
import com.paystack.android.core.logging.Logger

/**
 * An abstraction for the OTP countdown timer to avoid references to android.os in the ViewModel
 * */
internal interface OtpCountdownTimer {
    fun start(onTick: (Long) -> Unit)

    fun clear()
}

internal class OtpCountdownTimerImpl : OtpCountdownTimer {
    private var countDownTimer: CountDownTimer? = null

    override fun start(onTick: (Long) -> Unit) {
        countDownTimer = object : CountDownTimer(OTP_RESEND_DELAY_MILLIS, COUNTDOWN_INTERVAL) {
            override fun onTick(millisUntilFinished: Long) {
                onTick(millisUntilFinished)
            }

            override fun onFinish() {
                onTick(0)
            }
        }

        countDownTimer?.start()
        Logger.debug("Started OTP countdown timer")
    }

    override fun clear() {
        Logger.debug("Clearing OTP countdown timer")
        countDownTimer?.cancel()
        countDownTimer = null
    }

    private companion object {
        const val OTP_RESEND_DELAY_MILLIS = 60000L
        const val COUNTDOWN_INTERVAL = 1000L
    }
}
