package com.paystack.android.ui.paymentchannels.mobilemoney.mpesa.numberform

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.paystack.android.core.api.models.AccessCodeData
import com.paystack.android.ui.data.transaction.TransactionRepository
import com.paystack.android.ui.models.MobileMoneyCharge
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update
import kotlinx.coroutines.launch

internal class MpesaNumberFormViewModel(
    private val transactionAccessData: AccessCodeData,
    private val providerKey: String,
    private val transactionRepository: TransactionRepository,
    private val resultDispatcher: CoroutineDispatcher = Dispatchers.Main
) : ViewModel() {
    private val _uiState = MutableStateFlow(
        MpesaNumberFormState(
            providerKey = providerKey,
            providers = transactionAccessData.channelOptions.mobileMoney.orEmpty(),
            amount = transactionAccessData.amount,
            currency = transactionAccessData.currency
        )
    )
    val uiState = _uiState.asStateFlow()

    private val _result = MutableStateFlow<Result<MobileMoneyCharge>?>(null)
    val result = _result.asStateFlow()

    fun onPhoneNumberChanged(phoneNumber: String) {
        _uiState.update { it.copy(phoneNumber = phoneNumber) }
    }

    fun submitForm() {
        viewModelScope.launch(resultDispatcher) {
            val state = _uiState.value
            if (!state.isPhoneNumberValid) return@launch
            _uiState.update { it.copy(isProcessing = true) }
            _result.value = transactionRepository.chargeMobileMoney(
                transactionId = transactionAccessData.id,
                provider = providerKey,
                phone = _uiState.value.phoneNumber
            )
            _uiState.update { it.copy(isProcessing = false) }
        }
    }
}
