package com.paystack.android.ui.paymentchannels.card

import android.content.Context
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import com.paystack.android.core.api.models.AccessCodeData
import com.paystack.android.ui.data.dataComponent
import com.paystack.android.ui.models.Charge
import com.paystack.android.ui.paymentchannels.card.auth.address.AddressFormViewModel
import com.paystack.android.ui.paymentchannels.card.auth.otp.OtpCountdownTimerImpl
import com.paystack.android.ui.paymentchannels.card.auth.otp.OtpFormViewModel
import com.paystack.android.ui.paymentchannels.card.auth.phone.PhoneNumberAuthViewModel
import com.paystack.android.ui.paymentchannels.card.auth.pin.PinFormViewModel
import com.paystack.android.ui.paymentchannels.card.auth.redirect.RedirectAuthViewModel
import com.paystack.android.ui.paymentchannels.card.cardform.views.CardDetailsViewModel
import com.paystack.android.ui.utilities.utilitiesComponent

internal class CardViewModelsProviderFactory(
    private val context: Context,
    private val transactionAccessData: AccessCodeData,
    private val onPaymentComplete: (Charge) -> Unit,
    private val onError: (Throwable) -> Unit,
) : ViewModelProvider.Factory {

    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        return when (modelClass) {
            CardPaymentViewModel::class.java -> {
                CardPaymentViewModel(
                    transactionRepository = dataComponent().transactionRepository,
                    transactionAccessData = transactionAccessData,
                    stringProvider = utilitiesComponent(context).stringProvider,
                    onPaymentComplete = onPaymentComplete,
                    onError = onError
                ) as T
            }

            CardDetailsViewModel::class.java -> {
                CardDetailsViewModel(
                    transactionAccessData,
                    dataComponent().transactionRepository
                ) as T
            }

            PinFormViewModel::class.java -> PinFormViewModel(
                transactionAccessData,
                dataComponent().transactionRepository
            ) as T

            OtpFormViewModel::class.java -> {
                OtpFormViewModel(
                    transactionAccessData = transactionAccessData,
                    transactionRepository = dataComponent().transactionRepository,
                    otpCountdownTimer = OtpCountdownTimerImpl()
                ) as T
            }

            PhoneNumberAuthViewModel::class.java -> {
                PhoneNumberAuthViewModel(
                    transactionAccessData = transactionAccessData,
                    transactionRepository = dataComponent().transactionRepository,
                ) as T
            }

            AddressFormViewModel::class.java -> {
                AddressFormViewModel(
                    transactionAccessData = transactionAccessData,
                    transactionRepository = dataComponent().transactionRepository,
                ) as T
            }

            RedirectAuthViewModel::class.java -> {
                RedirectAuthViewModel(
                    transactionData = transactionAccessData,
                    transactionRepository = dataComponent().transactionRepository
                ) as T
            }

            else -> throw IllegalArgumentException("Unknown ViewModel class")
        }
    }
}
