/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android_sdk.ui.paymentchannels.card;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.paystack.android_sdk.core.api.models.AccessCodeData;
import com.paystack.android_sdk.ui.data.DataComponentKt;
import com.paystack.android_sdk.ui.models.Charge;
import com.paystack.android_sdk.ui.paymentchannels.card.CardPaymentViewModel;
import com.paystack.android_sdk.ui.paymentchannels.card.auth.address.AddressFormViewModel;
import com.paystack.android_sdk.ui.paymentchannels.card.auth.otp.OtpCountdownTimerImpl;
import com.paystack.android_sdk.ui.paymentchannels.card.auth.otp.OtpFormViewModel;
import com.paystack.android_sdk.ui.paymentchannels.card.auth.phone.PhoneNumberAuthViewModel;
import com.paystack.android_sdk.ui.paymentchannels.card.auth.pin.PinFormViewModel;
import com.paystack.android_sdk.ui.paymentchannels.card.auth.redirect.RedirectAuthViewModel;
import com.paystack.android_sdk.ui.paymentchannels.card.cardform.views.CardDetailsViewModel;
import com.paystack.android_sdk.ui.utilities.UtilitiesComponentKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\fJ%\u0010\r\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/paystack/android_sdk/ui/paymentchannels/card/CardViewModelsProviderFactory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "context", "Landroid/content/Context;", "transactionAccessData", "Lcom/paystack/android_sdk/core/api/models/AccessCodeData;", "onPaymentComplete", "Lkotlin/Function1;", "Lcom/paystack/android_sdk/ui/models/Charge;", "", "onError", "", "(Landroid/content/Context;Lcom/paystack/android_sdk/core/api/models/AccessCodeData;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "paystack-ui_release"})
public final class CardViewModelsProviderFactory
implements ViewModelProvider.Factory {
    @NotNull
    private final Context context;
    @NotNull
    private final AccessCodeData transactionAccessData;
    @NotNull
    private final Function1<Charge, Unit> onPaymentComplete;
    @NotNull
    private final Function1<Throwable, Unit> onError;

    public CardViewModelsProviderFactory(@NotNull Context context, @NotNull AccessCodeData transactionAccessData, @NotNull Function1<? super Charge, Unit> onPaymentComplete, @NotNull Function1<? super Throwable, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)transactionAccessData, (String)"transactionAccessData");
        Intrinsics.checkNotNullParameter(onPaymentComplete, (String)"onPaymentComplete");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        this.context = context;
        this.transactionAccessData = transactionAccessData;
        this.onPaymentComplete = onPaymentComplete;
        this.onError = onError;
    }

    @NotNull
    public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
        ViewModel viewModel;
        Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
        Class<T> clazz = modelClass;
        if (Intrinsics.areEqual(clazz, CardPaymentViewModel.class)) {
            viewModel = new CardPaymentViewModel(DataComponentKt.dataComponent().getTransactionRepository(), this.transactionAccessData, UtilitiesComponentKt.utilitiesComponent(this.context).getStringProvider(), this.onPaymentComplete, this.onError);
        } else if (Intrinsics.areEqual(clazz, CardDetailsViewModel.class)) {
            viewModel = new CardDetailsViewModel(this.transactionAccessData, DataComponentKt.dataComponent().getTransactionRepository());
        } else if (Intrinsics.areEqual(clazz, PinFormViewModel.class)) {
            viewModel = new PinFormViewModel(this.transactionAccessData, DataComponentKt.dataComponent().getTransactionRepository());
        } else if (Intrinsics.areEqual(clazz, OtpFormViewModel.class)) {
            viewModel = new OtpFormViewModel(this.transactionAccessData, DataComponentKt.dataComponent().getTransactionRepository(), new OtpCountdownTimerImpl());
        } else if (Intrinsics.areEqual(clazz, PhoneNumberAuthViewModel.class)) {
            viewModel = new PhoneNumberAuthViewModel(this.transactionAccessData, DataComponentKt.dataComponent().getTransactionRepository());
        } else if (Intrinsics.areEqual(clazz, AddressFormViewModel.class)) {
            viewModel = new AddressFormViewModel(this.transactionAccessData, DataComponentKt.dataComponent().getTransactionRepository());
        } else if (Intrinsics.areEqual(clazz, RedirectAuthViewModel.class)) {
            viewModel = new RedirectAuthViewModel(this.transactionAccessData, DataComponentKt.dataComponent().getTransactionRepository());
        } else {
            throw new IllegalArgumentException("Unknown ViewModel class");
        }
        return (T)viewModel;
    }
}

