package com.paystack.android_sdk.ui.paymentchannels.card.auth.redirect

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.paystack.android_sdk.core.api.models.AccessCodeData
import com.paystack.android_sdk.ui.data.transaction.TransactionRepository
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update
import kotlinx.coroutines.launch

internal class RedirectAuthViewModel(
    private val transactionData: AccessCodeData,
    private val transactionRepository: TransactionRepository,
) : ViewModel() {

    private var _state: MutableStateFlow<RedirectAuthState> = MutableStateFlow(RedirectAuthState())
    val state: StateFlow<RedirectAuthState> = _state.asStateFlow()

    fun startWebAuth() {
        _state.update { it.copy(launchWebUrl = true) }
        listenFor3dsResult()
    }

    private fun listenFor3dsResult() {
        viewModelScope.launch {
            val result = transactionRepository.await3dsResult(transactionData.id)
            _state.update { it.copy(result = result) }
        }
    }
}
