package com.paystack.android_sdk.ui.paymentsheet

import android.os.Parcelable
import com.paystack.android_sdk.ui.models.Charge
import kotlinx.parcelize.Parcelize

/**
 * The result of an payment attempt
 */
sealed class PaymentSheetResult : Parcelable {

    /**
     * The customer's payment process is complete.
     *
     * Your server should verify the transaction status and amount before providing value.
     * A transaction can be confirmed by using either webhooks or the verify transactions endpoint.
     *
     * See [Paystack's docs](https://paystack.com/docs/payments/verify-payments/)
     */
    @Parcelize
    data class Completed(val charge: Charge) : PaymentSheetResult()

    /**
     * The customer canceled the payment attempt.
     */
    @Parcelize
    object Cancelled : PaymentSheetResult()

    /**
     * The payment or setup attempt failed.
     * @param error The error encountered by the customer.
     */
    @Parcelize
    data class Failed(val error: Throwable, val reference: String?) : PaymentSheetResult()
}
