package com.paystack.android_sdk.ui.components.buttons

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.ButtonDefaults
import androidx.compose.material3.OutlinedButton
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import com.paystack.android_sdk.ui.components.progressbars.LoadingIndicator
import com.paystack.android_sdk.ui.theme.loadingIndicatorSize
import com.paystack.androiddesignsystem.PaystackTheme

@Composable
fun PrimaryButton(
    buttonText: String,
    onClick: () -> Unit,
    modifier: Modifier = Modifier,
    isEnabled: Boolean = false,
    isLoading: Boolean = false
) {

    OutlinedButton(
        modifier = modifier.fillMaxWidth(),
        onClick = onClick,
        colors = ButtonDefaults.buttonColors(
            containerColor = PaystackTheme.colors.secondaryColors.stackGreen,
            contentColor = PaystackTheme.colors.neutralColors.white,
            disabledContainerColor = PaystackTheme.colors.secondaryColors.stackGreen.copy(alpha = 0.6f),
            disabledContentColor = PaystackTheme.colors.neutralColors.white
        ),
        border = BorderStroke(width = 0.dp, color = Color.Transparent),
        contentPadding = PaddingValues(PaystackTheme.dimensions.spacing.double),
        enabled = isEnabled && !isLoading,
        shape = RoundedCornerShape(PaystackTheme.dimensions.borderRadius.medium)
    ) {

        if (isLoading) {
            LoadingIndicator(modifier = Modifier.size(PaystackTheme.dimensions.loadingIndicatorSize))
        } else {
            Text(
                text = buttonText,
                style = PaystackTheme.typography.body.body16M,
            )
        }
    }
}
