package com.paystack.android.ui.paymentchannels.mobilemoney.mpesa.offline

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.material3.ShapeDefaults
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringArrayResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.tooling.preview.Preview
import com.paystack.android.ui.R
import com.paystack.android.ui.components.buttons.SecondaryButton
import com.paystack.android.ui.theme.PaystackTheme

@Composable
internal fun PayWithLipaSteps(
    onBackClick: () -> Unit,
    modifier: Modifier = Modifier
) {
    val payWithLipaSteps = stringArrayResource(id = R.array.pstk_lipa_steps)

    Column(
        modifier = modifier,
        horizontalAlignment = Alignment.CenterHorizontally
    ) {
        Text(
            text = stringResource(R.string.pstk_how_to_lipa_steps),
            style = PaystackTheme.typography.body.body16M,
            textAlign = TextAlign.Center,
            modifier = Modifier
                .fillMaxWidth()
                .padding(horizontal = PaystackTheme.dimensions.spacing.triple)
        )

        Spacer(Modifier.height(PaystackTheme.dimensions.spacing.double))

        Surface(
            color = PaystackTheme.colors.primaryColors.navy06,
            shape = ShapeDefaults.Large,
            modifier = Modifier.fillMaxWidth()
        ) {
            Column(
                verticalArrangement = Arrangement.spacedBy(PaystackTheme.dimensions.spacing.single),
                modifier = Modifier.padding(PaystackTheme.dimensions.spacing.double)
            ) {
                payWithLipaSteps.forEach {
                    Row(
                        verticalAlignment = Alignment.CenterVertically,
                        horizontalArrangement = Arrangement.Center,
                        modifier = Modifier.padding(bottom = PaystackTheme.dimensions.spacing.single)
                    ) {
                        Box(
                            modifier = Modifier
                                .padding(end = PaystackTheme.dimensions.spacing.single)
                                .size(PaystackTheme.dimensions.spacing.half)
                                .background(
                                    PaystackTheme.colors.secondaryColors.stackGreen,
                                    shape = CircleShape
                                )
                        )
                        Text(
                            text = it,
                            style = PaystackTheme.typography.body.body14R,
                            color = PaystackTheme.colors.primaryColors.stackBlue
                        )
                    }
                }
            }
        }

        Spacer(Modifier.height(PaystackTheme.dimensions.spacing.triple))

        SecondaryButton(
            text = stringResource(id = R.string.pstk_from_lipa_steps_back_to_payment),
            onClick = onBackClick,
            modifier = Modifier.fillMaxWidth(),
            showBorder = true,
            borderColor = PaystackTheme.colors.neutralColors.silver,
            contentColor = PaystackTheme.colors.primaryColors.navy01
        )
    }
}

@Preview
@Composable
private fun PayWithLipaPreview() {
    Surface {
        Column(
            modifier = Modifier
                .fillMaxSize()
                .padding(PaystackTheme.dimensions.spacing.double)
        ) {
            PayWithLipaSteps({})
        }
    }
}
