package com.paystack.android.ui.components.views.dialog

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.wrapContentHeight
import androidx.compose.foundation.layout.wrapContentWidth
import androidx.compose.material3.AlertDialog
import androidx.compose.material3.AlertDialogDefaults
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import com.paystack.android.ui.theme.PaystackTheme

@OptIn(ExperimentalMaterial3Api::class)
@Composable
internal fun PaymentDialog(
    dialogText: String,
    dismissText: String,
    confirmText: String,
    onDismissOptionSelected: () -> Unit,
    onPositiveOptionSelected: () -> Unit,
) {
    AlertDialog(onDismissRequest = {}) {
        Surface(
            modifier = Modifier
                .wrapContentWidth()
                .wrapContentHeight(),
            shape = MaterialTheme.shapes.large,
            tonalElevation = AlertDialogDefaults.TonalElevation
        ) {

            Column(modifier = Modifier.padding(PaystackTheme.dimensions.spacing.double)) {
                Text(
                    modifier = Modifier.padding(PaystackTheme.dimensions.spacing.double),
                    text = dialogText, style = PaystackTheme.typography.body.body14R
                )
                Spacer(modifier = Modifier.height(PaystackTheme.dimensions.spacing.double))
                Row(modifier = Modifier.fillMaxWidth(), horizontalArrangement = Arrangement.End) {
                    TextButton(
                        onClick = onDismissOptionSelected,
                        content = {
                            Text(
                                text = dismissText,
                                style = PaystackTheme.typography.body.body14M,
                                color = PaystackTheme.colors.primaryColors.stackBlue
                            )
                        })
                    TextButton(
                        onClick = onPositiveOptionSelected,
                        content = {
                            Text(
                                text = confirmText, style = PaystackTheme.typography.body.body14M,
                                color = PaystackTheme.colors.primaryColors.stackBlue
                            )
                        }
                    )
                }
            }
        }
    }
}
