package com.paystack.android.ui.components.bottomsheet

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.ModalBottomSheet
import androidx.compose.material3.rememberModalBottomSheetState
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.rememberCoroutineScope
import androidx.compose.runtime.snapshotFlow
import androidx.compose.ui.Modifier
import com.paystack.android.ui.theme.PaystackTheme
import com.paystack.android.ui.theme.bottomSheetHeight

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun ChargeServiceBottomSheet(
    uiState: ModalBottomSheetViewState,
    content: @Composable () -> Unit,
) {

    val bottomSheetState =
        rememberModalBottomSheetState(skipPartiallyExpanded = true, confirmValueChange = { false })
    val scope = rememberCoroutineScope()

    val bottomSheetDelegate = BottomSheetDelegateImpl(state = bottomSheetState, scope = scope)

    LaunchedEffect(key1 = uiState.bottomSheetAction) {
        when (uiState.bottomSheetAction) {
            BottomSheetActions.INITIAL -> {}

            BottomSheetActions.HIDE -> {
                bottomSheetDelegate.hide()
            }

            BottomSheetActions.SHOW -> {
                bottomSheetDelegate.show()
            }
        }
    }

    // todo - use to reset state
    LaunchedEffect(Unit) {
        snapshotFlow { }
    }

    if (uiState.bottomSheetAction == BottomSheetActions.SHOW) {
        ModalBottomSheet(
            onDismissRequest = { },
            sheetState = bottomSheetState,
            content = {
                Column(Modifier.fillMaxSize(PaystackTheme.dimensions.bottomSheetHeight)) {
                    content()
                }
            }
        )
    }
}
