package com.paystack.android.ui.components.bottomsheet

/**
 * Content classes and object for each BottomSheet type
 *
 */
sealed class BottomSheetContent {

    /**
     * The Payment composable that will be shown during the payment step
     */

    data class PaymentContent(val placeHolder: String) : BottomSheetContent()

    /**
     * The result composable that will be shown after the payment step has been completed
     *
     */
    data class ResultContent(val placeHolder: String) : BottomSheetContent()

    /**
     * Empty Initial state.
     */
    object InitialSheetContent : BottomSheetContent()
}
