/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android.core.events.pusher;

import com.paystack.android.core.events.EventManager;
import com.paystack.android.core.events.Subscription;
import com.paystack.android.core.events.SubscriptionParams;
import com.paystack.android.core.events.pusher.PusherFactory;
import com.paystack.android.core.logging.Logger;
import com.pusher.client.Pusher;
import com.pusher.client.channel.Channel;
import com.pusher.client.channel.ChannelEventListener;
import com.pusher.client.channel.PusherEvent;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.ConnectionStateChange;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000f0\u0016H\u0016J\u001a\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/paystack/android/core/events/pusher/PusherEventManager;", "Lcom/paystack/android/core/events/EventManager;", "pusherFactory", "Lcom/paystack/android/core/events/pusher/PusherFactory;", "(Lcom/paystack/android/core/events/pusher/PusherFactory;)V", "activeSubscribedChannels", "", "Lcom/pusher/client/channel/Channel;", "pusher", "Lcom/pusher/client/Pusher;", "getPusher", "()Lcom/pusher/client/Pusher;", "pusher$delegate", "Lkotlin/Lazy;", "connect", "", "disconnect", "subscribe", "Lcom/paystack/android/core/events/Subscription;", "params", "Lcom/paystack/android/core/events/SubscriptionParams;", "onEvent", "Lkotlin/Function1;", "", "unsubscribe", "channelName", "subscribedChannel", "paystack-core_release"})
public final class PusherEventManager
implements EventManager {
    @NotNull
    private final PusherFactory pusherFactory;
    @NotNull
    private final Lazy pusher$delegate;
    @NotNull
    private List<Channel> activeSubscribedChannels;

    public PusherEventManager(@NotNull PusherFactory pusherFactory) {
        Intrinsics.checkNotNullParameter((Object)pusherFactory, (String)"pusherFactory");
        this.pusherFactory = pusherFactory;
        this.pusher$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pusher>(this){
            final /* synthetic */ PusherEventManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Pusher invoke() {
                return PusherEventManager.access$getPusherFactory$p(this.this$0).create();
            }
        }));
        this.activeSubscribedChannels = new ArrayList();
    }

    private final Pusher getPusher() {
        Lazy lazy = this.pusher$delegate;
        return (Pusher)lazy.getValue();
    }

    private final void connect() {
        ConnectionState[] connectionStateArray = new ConnectionState[]{ConnectionState.ALL};
        this.getPusher().connect(new ConnectionEventListener(){

            public void onConnectionStateChange(@NotNull ConnectionStateChange change) {
                Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                Logger.INSTANCE.debug("State changed from " + change.getPreviousState() + " to " + change.getCurrentState());
            }

            public void onError(@NotNull String message, @Nullable String code, @Nullable Exception e) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Logger.INSTANCE.error(e, "Pusher Connection error! Code: (" + code + ")");
            }
        }, connectionStateArray);
    }

    @Override
    @NotNull
    public Subscription subscribe(@NotNull SubscriptionParams params, @NotNull Function1<? super String, Unit> onEvent) {
        Channel channel;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(onEvent, (String)"onEvent");
        String channelName = params.component1();
        String eventName = params.component2();
        ChannelEventListener channelEventListener2 = new ChannelEventListener(onEvent){
            final /* synthetic */ Function1<String, Unit> $onEvent;
            {
                this.$onEvent = $onEvent;
            }

            public void onEvent(@NotNull PusherEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                String string = event.getData();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.data");
                this.$onEvent.invoke((Object)string);
            }

            public void onSubscriptionSucceeded(@NotNull String channelName) {
                Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
                Logger.INSTANCE.debug("Subscribed to " + channelName);
            }
        };
        this.connect();
        Channel activeChannel = this.getPusher().getChannel(channelName);
        if (activeChannel == null) {
            stringArray = new String[]{eventName};
            channel = this.getPusher().subscribe(channelName, channelEventListener2, stringArray);
        } else {
            this.getPusher().unsubscribe(channelName);
            stringArray = new String[]{eventName};
            channel = this.getPusher().subscribe(channelName, channelEventListener2, stringArray);
        }
        Channel subscribedChannel = channel;
        this.activeSubscribedChannels.add(subscribedChannel);
        return () -> PusherEventManager.subscribe$lambda$0(this, channelName, subscribedChannel);
    }

    @Override
    public void unsubscribe(@NotNull String channelName, @Nullable Channel subscribedChannel) {
        Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
        Channel channel = subscribedChannel;
        boolean bl = channel != null ? channel.isSubscribed() : false;
        if (bl) {
            this.getPusher().unsubscribe(channelName);
            this.activeSubscribedChannels.remove(subscribedChannel);
        }
    }

    private final void disconnect() {
        if (this.activeSubscribedChannels.isEmpty()) {
            this.getPusher().disconnect();
        }
    }

    private static final void subscribe$lambda$0(PusherEventManager this$0, String $channelName, Channel $subscribedChannel) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$channelName, (String)"$channelName");
        this$0.unsubscribe($channelName, $subscribedChannel);
        this$0.disconnect();
    }

    public static final /* synthetic */ PusherFactory access$getPusherFactory$p(PusherEventManager $this) {
        return $this.pusherFactory;
    }
}

