/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android.core.api.core;

import android.os.Build;
import androidx.annotation.OpenForTesting;
import com.paystack.android.core.api.utilities.StringExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0003H\u0001\u001a\f\u0010\u0004\u001a\u00020\u0003*\u00020\u0003H\u0001\u001a\f\u0010\u0005\u001a\u00020\u0003*\u00020\u0003H\u0001\u00a8\u0006\u0006"}, d2={"getDeviceName", "", "addDeviceIdentifierHeader", "Lokhttp3/Request$Builder;", "addDeviceInfoHeaders", "addSdkVersionHeader", "paystack-core_release"})
public final class RequestHeadersExtKt {
    @OpenForTesting
    @NotNull
    public static final Request.Builder addDeviceInfoHeaders(@NotNull Request.Builder $this$addDeviceInfoHeaders) {
        Intrinsics.checkNotNullParameter((Object)$this$addDeviceInfoHeaders, (String)"<this>");
        $this$addDeviceInfoHeaders.addHeader("x-platform", "AndroidSDK");
        $this$addDeviceInfoHeaders.addHeader("x-platform-version", String.valueOf(Build.VERSION.SDK_INT));
        $this$addDeviceInfoHeaders.addHeader("x-device", RequestHeadersExtKt.getDeviceName());
        return $this$addDeviceInfoHeaders;
    }

    @OpenForTesting
    @NotNull
    public static final Request.Builder addDeviceIdentifierHeader(@NotNull Request.Builder $this$addDeviceIdentifierHeader) {
        Intrinsics.checkNotNullParameter((Object)$this$addDeviceIdentifierHeader, (String)"<this>");
        $this$addDeviceIdentifierHeader.addHeader("x-device-identifier", "sdk_android_");
        return $this$addDeviceIdentifierHeader;
    }

    @OpenForTesting
    @NotNull
    public static final Request.Builder addSdkVersionHeader(@NotNull Request.Builder $this$addSdkVersionHeader) {
        Intrinsics.checkNotNullParameter((Object)$this$addSdkVersionHeader, (String)"<this>");
        $this$addSdkVersionHeader.addHeader("x-sdk-version", "0.0.9");
        return $this$addSdkVersionHeader;
    }

    private static final String getDeviceName() {
        String manufacturer = Build.MANUFACTURER;
        String model = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)model, (String)"model");
        Intrinsics.checkNotNullExpressionValue((Object)manufacturer, (String)"manufacturer");
        return StringsKt.startsWith$default((String)model, (String)manufacturer, (boolean)false, (int)2, null) ? StringExtKt.capitalize(model) : StringExtKt.capitalize(manufacturer) + " " + model;
    }
}

