package com.paystack.android.core.api.services.transactions

import com.paystack.android.core.api.ApiRequest
import com.paystack.android.core.api.models.AccessCodeData
import com.paystack.android.core.api.models.ChargeResponse
import com.paystack.android.core.api.models.PaymentChannel

interface PaystackTransactionService {
    fun verifyAccessCode(accessCode: String): ApiRequest<AccessCodeData>

    /**
     * Creates an [ApiRequest] gets the Charge state for a pending transaction.
     *
     * @return An [ApiRequest] for [ChargeResponse]
     */
    fun checkPendingCharge(accessCode: String): ApiRequest<ChargeResponse>

    /**
     * Returns a list of payment channels supported by the SDK
     */
    fun getSupportedPaymentChannels(): List<PaymentChannel>

    /**
     * Listens for transaction events on a channel.
     * @param channel The channel to listen on
     * @param callback The callback to invoke when a transaction event is received
     */
    fun listenForTransactionEvent(channnel: String, callback: TransactionEventListener)
}
