package com.paystack.android.core.api.models

import com.paystack.android.core.logging.Logger
import kotlinx.serialization.KSerializer
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.descriptors.serialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder

@Serializable
data class MobileMoneyChargeResponse(
    @SerialName("channel_name")
    val channelName: String,
    @SerialName("display")
    val displayParams: DisplayParams,
    @SerialName("phone")
    val phone: String? = null,
    @SerialName("provider")
    val provider: String,
    @SerialName("transaction")
    val transactionId: String
) {
    @Serializable
    data class DisplayParams(
        @SerialName("message")
        val message: String,
        @SerialName("timer")
        val timer: Int,
        @SerialName("type")
        val type: DisplayType,
        @SerialName("gatewayAccount")
        val paybillNumber: String? = null,
        @SerialName("gatewayReference")
        val accountNumber: String? = null
    )

    @Serializable(with = DisplayType.Serializer::class)
    enum class DisplayType {
        @SerialName("enter_number")
        ENTER_NUMBER,

        @SerialName("pop")
        POP,

        @SerialName("mpesa_offline_payment_instructions")
        MPESA_OFFLINE_PAYMENT_INSTRUCTIONS,

        UNSUPPORTED;

        object Serializer : KSerializer<DisplayType> {
            override val descriptor: SerialDescriptor
                get() = serialDescriptor<String>()

            override fun serialize(encoder: Encoder, value: DisplayType) {
                encoder.encodeString(value.name.lowercase())
            }

            override fun deserialize(decoder: Decoder): DisplayType {
                val value = decoder.decodeString().uppercase()
                return try {
                    enumValueOf(value)
                } catch (e: IllegalArgumentException) {
                    Logger.error(e, e.message ?: "Unknown enum value: $value")
                    UNSUPPORTED
                }
            }
        }
    }
}
