package com.paystack.android.core.api.models

import android.os.Parcelable
import kotlinx.parcelize.Parcelize
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Parcelize
@Serializable
data class AccessCodeData(
    @SerialName("id")
    val id: String,
    @SerialName("access_code")
    val accessCode: String,
    @SerialName("amount")
    val amount: Long,
    @SerialName("channels")
    private val _channels: List<PaymentChannel>,
    @SerialName("currency")
    val currency: String,
    @SerialName("domain")
    val domain: PaystackDomain,
    @SerialName("email")
    val email: String,
    @SerialName("merchant_name")
    val merchantName: String,
    @SerialName("reference")
    val reference: String,
    @SerialName("public_encryption_key")
    val encryptionKey: String,
    @SerialName("channel_options")
    val channelOptions: ChannelOptions,
) : Parcelable {
    val isTestTransaction: Boolean
        get() = domain == PaystackDomain.TEST

    /**
     * Returns a list of payment channels known by the SDK
     */
    val channels: List<PaymentChannel>
        get() = _channels.filterNot { it == PaymentChannel.UNKNOWN }
}
