package com.paystack.android.core.events

import com.paystack.android.core.BuildConfig
import com.paystack.android.core.events.pusher.PusherEventManager
import com.pusher.client.Pusher
import com.pusher.client.PusherOptions

internal fun eventsComponent(): EventsComponent = EventsModule

internal interface EventsComponent {
    val eventManager: EventManager
}

internal object EventsModule : EventsComponent {
    override val eventManager: EventManager by lazy {
        val options = PusherOptions()
        options.setCluster("eu")
        PusherEventManager(Pusher(BuildConfig.PUSHER_KEY, options))
    }
}
