package com.paystack.android.core.api.utilities

import java.text.SimpleDateFormat
import java.util.Locale

/**
 * Checks if date is valid
 *
 * @return [Boolean] true if date is valid else false
 */
internal fun isDateValid(year: String, month: String, day: String): Boolean {
    val dateFormat = SimpleDateFormat("yyyy-MM-dd", Locale.getDefault())
    dateFormat.isLenient = false

    val isValidDate = runCatching {
        dateFormat.parse("$year-$month-$day")
    }.isSuccess
    return isValidDate
}
