package com.paystack.android.core.api.models

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class RedirectAuthResponse(
    val status: TransactionStatus,
    @SerialName("trans")
    val transactionId: String?,
    @SerialName("trxref")
    private val trxRef: String?,
    @SerialName("reference")
    private val ref: String?,
    val message: String?,
    val response: String?,
) {

    /**
     * Returns the transaction reference for this response.
     * This exists because the backend returns two values.
     *
     * This is either [ref] or [trxRef]
     */
    val reference: String?
        get() = ref ?: trxRef
}
