package com.paystack.android.core.api

import com.paystack.android.core.api.models.PaystackError
import kotlin.coroutines.resume
import kotlin.coroutines.resumeWithException
import kotlin.coroutines.suspendCoroutine

interface ApiRequest<T> {
    fun execute(callback: ApiRequestCallback<T>)
}

/**
 * Executes [ApiRequest] instance as a coroutine
 *
 * @return [T] remote response error type.
 */
suspend fun <T> ApiRequest<T>.await(): T {
    return suspendCoroutine { continuation ->
        execute(object : ApiRequestCallback<T> {
            override fun onSuccess(data: T) {
                continuation.resume(data)
            }

            override fun onError(error: PaystackError) {
                continuation.resumeWithException(error)
            }
        })
    }
}
