/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android.core.api;

import com.paystack.android.core.api.ApiRequest;
import com.paystack.android.core.api.ApiRequestCallback;
import com.paystack.android.core.api.RetrofitApiRequest;
import com.paystack.android.core.api.core.exceptions.NoResponseBodyError;
import com.paystack.android.core.api.extensions.ApiResponse;
import com.paystack.android.core.api.models.ErrorResponse;
import com.paystack.android.core.api.models.PaystackError;
import com.paystack.android.core.api.models.PaystackErrorKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016J \u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0002J&\u0010\u0010\u001a\u00020\n2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/paystack/android/core/api/RetrofitApiRequest;", "T", "Lcom/paystack/android/core/api/ApiRequest;", "call", "Lretrofit2/Call;", "Lcom/paystack/android/core/api/extensions/ApiResponse;", "(Lretrofit2/Call;)V", "json", "Lkotlinx/serialization/json/Json;", "execute", "", "callback", "Lcom/paystack/android/core/api/ApiRequestCallback;", "handleErrorResponse", "errorBody", "Lokhttp3/ResponseBody;", "handleSuccessfulResponse", "apiResponse", "paystack-core_release"})
@SourceDebugExtension(value={"SMAP\nRetrofitApiRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetrofitApiRequest.kt\ncom/paystack/android/core/api/RetrofitApiRequest\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 Serializers.kt\nkotlinx/serialization/SerializersKt__SerializersKt\n+ 4 Platform.common.kt\nkotlinx/serialization/internal/Platform_commonKt\n*L\n1#1,73:1\n123#2:74\n32#3:75\n80#4:76\n*S KotlinDebug\n*F\n+ 1 RetrofitApiRequest.kt\ncom/paystack/android/core/api/RetrofitApiRequest\n*L\n61#1:74\n61#1:75\n61#1:76\n*E\n"})
public final class RetrofitApiRequest<T>
implements ApiRequest<T> {
    @NotNull
    private final Call<ApiResponse<T>> call;
    @NotNull
    private final Json json;

    public RetrofitApiRequest(@NotNull Call<ApiResponse<T>> call) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        this.call = call;
        this.json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
    }

    @Override
    public void execute(@NotNull ApiRequestCallback<T> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.call.enqueue(new Callback<ApiResponse<T>>(this, callback){
            final /* synthetic */ RetrofitApiRequest<T> this$0;
            final /* synthetic */ ApiRequestCallback<T> $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onResponse(@NotNull Call<ApiResponse<T>> call, @NotNull Response<ApiResponse<T>> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.isSuccessful()) {
                    RetrofitApiRequest.access$handleSuccessfulResponse(this.this$0, (ApiResponse)response.body(), this.$callback);
                } else {
                    RetrofitApiRequest.access$handleErrorResponse(this.this$0, response.errorBody(), this.$callback);
                }
            }

            public void onFailure(@NotNull Call<ApiResponse<T>> call, @NotNull Throwable exception) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.$callback.onError(PaystackErrorKt.asPaystackError(exception));
            }
        });
    }

    private final void handleSuccessfulResponse(ApiResponse<T> apiResponse, ApiRequestCallback<T> callback) {
        T data;
        ApiResponse<T> apiResponse2 = apiResponse;
        Object object = data = apiResponse2 != null ? apiResponse2.getData() : null;
        if (data != null) {
            callback.onSuccess(data);
        } else {
            callback.onError(PaystackErrorKt.asPaystackError(new NoResponseBodyError(null, 1, null)));
        }
    }

    private final void handleErrorResponse(ResponseBody errorBody, ApiRequestCallback<T> callback) {
        PaystackError paystackError;
        Object object = errorBody;
        if (object == null || (object = object.string()) == null) {
            RetrofitApiRequest $this$handleErrorResponse_u24lambda_u240 = this;
            boolean bl = false;
            callback.onError(new PaystackError("An error occurred", null, 2, null));
            return;
        }
        Object errorStr = object;
        try {
            StringFormat $this$decodeFromString$iv = (StringFormat)this.json;
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(ErrorResponse.class));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            ErrorResponse errorResponse = (ErrorResponse)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, (String)errorStr);
            paystackError = new PaystackError(errorResponse.getMessage(), null, 2, null);
        }
        catch (SerializationException e) {
            paystackError = PaystackErrorKt.asPaystackError(e);
        }
        PaystackError error = paystackError;
        callback.onError(error);
    }

    public static final /* synthetic */ void access$handleSuccessfulResponse(RetrofitApiRequest $this, ApiResponse apiResponse, ApiRequestCallback callback) {
        $this.handleSuccessfulResponse(apiResponse, callback);
    }

    public static final /* synthetic */ void access$handleErrorResponse(RetrofitApiRequest $this, ResponseBody errorBody, ApiRequestCallback callback) {
        $this.handleErrorResponse(errorBody, callback);
    }
}

