package com.paystack.android_sdk.core.events.pusher

import com.paystack.android_sdk.core.events.EventManager
import com.paystack.android_sdk.core.events.Subscription
import com.paystack.android_sdk.core.events.SubscriptionParams
import com.paystack.android_sdk.core.logging.Logger
import com.pusher.client.Pusher
import com.pusher.client.channel.ChannelEventListener
import com.pusher.client.channel.PusherEvent
import com.pusher.client.connection.ConnectionEventListener
import com.pusher.client.connection.ConnectionState
import com.pusher.client.connection.ConnectionStateChange

internal class PusherEventManager(private val pusher: Pusher) : EventManager {

    init {
        connect()
    }

    private fun connect() {
        pusher.connect(object : ConnectionEventListener {
            override fun onConnectionStateChange(change: ConnectionStateChange) {
                Logger.debug("State changed from ${change.previousState} to ${change.currentState}")
            }

            override fun onError(message: String, code: String?, e: Exception?) {
                Logger.error(
                    errorMessage = "Connection error! Code: ($code), message ($message), exception($e)",
                    throwable = e
                )
            }
        }, ConnectionState.ALL)
    }

    override fun subscribe(
        params: SubscriptionParams,
        onEvent: (String) -> Unit,
    ): Subscription {
        val (channelName, eventName) = params
        val channelEventListener = object : ChannelEventListener {
            override fun onEvent(event: PusherEvent) {
                onEvent(event.data)
            }

            override fun onSubscriptionSucceeded(channelName: String) {
                Logger.debug("Subscribed to $channelName")
            }
        }
        pusher.subscribe(channelName, channelEventListener, eventName)

        return Subscription { unsubscribe(channelName) }
    }

    override fun unsubscribe(channelName: String) {
        pusher.unsubscribe(channelName)
    }
}
