package com.paystack.android_sdk.core.logging

import android.util.Log
import androidx.annotation.RestrictTo

@RestrictTo(RestrictTo.Scope.LIBRARY_GROUP)
object Logger {

    /**
     * if Enabled, log messages will be omitted to the console.
     */
    var isEnabled: Boolean = false

    /**
     * This method is responsible for logging debug level messages to the console
     *
     * @param message - a message in the form of a String that needs to be emitted to the log
     * when this method is called.
     *
     */
    fun verbose(message: String) {
        if (isEnabled) Log.v(LOG_TAG, message)
    }

    /**
     * Informational log message shown in the event log
     *
     * @param message a message in the form of a String that needs to be emitted to the log
     * when this method is called.
     */
    fun info(message: String) {
        if (isEnabled) Log.i(LOG_TAG, message)
    }

    /**
     * Debug log message shown in the event log that could be useful in debugging
     * SDK events for the purpose of solving an issue
     *
     *@param message a message in the form of a String that needs to be emitted to the log
     * with debug information
     *
     */

    fun debug(message: String) {
        if (isEnabled) Log.d(LOG_TAG, message)
    }

    /**
     * This method logs all error events to the console
     *
     * @param errorMessage a message in the form of a String that needs to be emitted to the log
     * when this method is called.
     * @param throwable the cause of the error thrown.
     */
    fun error(errorMessage: String, throwable: Throwable?) {
        if (isEnabled) Log.e(LOG_TAG, errorMessage, throwable)
    }

    /**
     * We're unable to use the full package ID due to android logger tag character limitations
     */
    private const val LOG_TAG = "paystack.androidsdk"
}
