package com.paystack.android_sdk.core.api.transactions

import com.paystack.android_sdk.core.api.extensions.ApiResponse
import com.paystack.android_sdk.core.api.models.AccessCodeData
import com.paystack.android_sdk.core.api.models.AddressState
import com.paystack.android_sdk.core.api.models.ChargeRequest
import com.paystack.android_sdk.core.api.models.ChargeResponse
import com.paystack.android_sdk.core.api.models.SubmitAddressRequest
import com.paystack.android_sdk.core.api.models.SubmitBirthdayRequest
import com.paystack.android_sdk.core.api.models.SubmitOtpRequest
import com.paystack.android_sdk.core.api.models.SubmitPhoneRequest
import com.paystack.android_sdk.core.api.models.SubmitPinRequest
import retrofit2.Call
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.Path
import retrofit2.http.Query

internal interface TransactionApi {
    @GET("/transaction/verify_access_code/{access_code}")
    fun verifyAccessCode(@Path("access_code") accessCode: String): Call<ApiResponse<AccessCodeData>>

    @POST("/transaction/charge")
    fun charge(@Body chargeRequest: ChargeRequest): Call<ApiResponse<ChargeResponse>>

    @GET("/transaction/charge/{access_code}")
    fun checkPendingCharge(@Path("access_code") accessCode: String): Call<ApiResponse<ChargeResponse>>

    @GET("/address_verification/states")
    fun getAvsStates(@Query("country") countryCode: String): Call<ApiResponse<List<AddressState>>>

    @POST("/transaction/charge/submit_address")
    fun submitAddress(@Body request: SubmitAddressRequest): Call<ApiResponse<ChargeResponse>>

    @POST("/transaction/charge/submit_pin")
    fun submitPin(@Body request: SubmitPinRequest): Call<ApiResponse<ChargeResponse>>

    @POST("/transaction/charge/submit_otp")
    fun submitOtp(@Body request: SubmitOtpRequest): Call<ApiResponse<ChargeResponse>>

    @POST("/transaction/charge/submit_phone")
    fun submitPhone(@Body request: SubmitPhoneRequest): Call<ApiResponse<ChargeResponse>>

    @POST("/transaction/charge/submit_birthday")
    fun submitBirthday(@Body request: SubmitBirthdayRequest): Call<ApiResponse<ChargeResponse>>
}
