package com.paystack.android_sdk.core.api.models

import android.os.Parcelable
import kotlinx.parcelize.Parcelize
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 *
 * @param code
 * @param bin
 * @param last4
 * @param expiryMonth
 * @param expiryYear
 * @param cardType
 * @param countryCode
 * @param bank
 * @param brand
 * @param reusable
 * @param signature
 */
@Serializable
@Parcelize
data class ChargeAuthorization internal constructor(
    @SerialName("authorization_code")
    val code: String,
    val bin: String,
    val last4: String,
    @SerialName("exp_month")
    val expiryMonth: String,
    @SerialName("exp_year")
    val expiryYear: String,
    @SerialName("card_type")
    val cardType: String,
    @SerialName("country_code")
    val countryCode: String,
    val bank: String,
    val brand: String,
    val reusable: Boolean,
    val signature: String,
) : Parcelable
