package com.paystack.android_sdk.core.api.models

import android.os.Parcelable
import kotlinx.parcelize.Parcelize
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Parcelize
@Serializable
data class AccessCodeData(
    @SerialName("id")
    val id: String,
    @SerialName("access_code")
    val accessCode: String,
    @SerialName("amount")
    val amount: Long,
    @SerialName("channels")
    val channels: List<String>,  // TODO: Use enum to represent channels,
    @SerialName("currency")
    val currency: String,
    @SerialName("domain")
    val domain: PaystackDomain,
    @SerialName("email")
    val email: String,
    @SerialName("merchant_name")
    val merchantName: String,
    @SerialName("reference")
    val reference: String,
    @SerialName("public_encryption_key")
    val encryptionKey: String,
) : Parcelable {
    val isTestTransaction: Boolean
        get() = domain == PaystackDomain.TEST
}
