package com.paystack.android_sdk.core.api.models

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
enum class TransactionStatus {
    @SerialName("success")
    Success,

    @SerialName("failed")
    Failed,

    @SerialName("pending")
    Pending,

    @SerialName("timeout")
    Timeout,

    @SerialName("send_otp")
    SentOtp,

    @SerialName("send_birthday")
    SendBirthday,

    @SerialName("send_pin")
    SendPin,

    @SerialName("send_address")
    SendAddress,

    @SerialName("send_phone")
    SendPhone,

    /**
     * External transaction authentication is required.
     * The user should be redirected to [ChargeResponse.authUrl] to complete the transaction.
     * This is applicable to 3DS transactions.
     */
    @SerialName("open_url")
    OpenUrl
}
