package com.paystack.android_sdk.core

import androidx.annotation.VisibleForTesting
import com.paystack.android_sdk.core.api.core.exceptions.KeyNotFoundException
import com.paystack.android_sdk.core.api.core.exceptions.SdkNotInitializedException

class Paystack(internal val config: PaystackConfig) {
    class Builder private constructor(
        private var publicKey: String? = null,
        private var loggingEnabled: Boolean = false,
    ) {
        @VisibleForTesting
        internal val config: PaystackConfig
            get() {
                val key = publicKey ?: throw KeyNotFoundException()
                return PaystackConfig(key, loggingEnabled)
            }

        fun setPublicKey(publicKey: String) = apply {
            this.publicKey = publicKey
        }

        fun setLoggingEnabled(loggingEnabled: Boolean) = apply {
            this.loggingEnabled = loggingEnabled
        }

        @Throws(IllegalStateException::class)
        fun build(): Paystack {
            return Paystack(config)
        }

        companion object {
            @Volatile
            private var _instance: Builder? = null

            @JvmStatic
            val instance: Builder
                get() {
                    synchronized(this) {
                        val checkInstance = _instance
                        if (checkInstance != null) {
                            return checkInstance
                        }
                        throw SdkNotInitializedException()
                    }
                }

            @JvmStatic
            internal fun init(): Builder {
                synchronized(this) {
                    _instance = Builder()
                    return instance
                }
            }
        }
    }

    companion object {
        @JvmStatic
        fun builder() = Builder.init()
    }
}
