package com.paystack.android.core.events.pusher

import com.paystack.android.core.BuildConfig
import com.pusher.client.Pusher
import com.pusher.client.PusherOptions

internal fun interface PusherFactory {
    fun create(): Pusher
}

internal val DefaultPusherFactory = PusherFactory {
    val pusherApiKey = BuildConfig.PUSHER_KEY
    val pusherCluster = BuildConfig.PUSHER_CLUSTER
    val options = PusherOptions()
    options.setCluster(pusherCluster.ifEmpty { "eu" })
    Pusher(pusherApiKey, options)
}
