package com.paystack.android.core.api.models

import com.paystack.android.core.logging.Logger
import kotlinx.serialization.KSerializer
import kotlinx.serialization.Serializable
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.descriptors.serialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder

@Serializable(with = PaymentChannel.PaymentChannelSerializer::class)
enum class PaymentChannel {
    CARD,
    MOBILE_MONEY,
    UNKNOWN;

    object PaymentChannelSerializer : KSerializer<PaymentChannel> {
        override val descriptor: SerialDescriptor
            get() = serialDescriptor<String>()

        override fun deserialize(decoder: Decoder): PaymentChannel {
            val value = decoder.decodeString().uppercase()
            return try {
                enumValueOf(value)
            } catch (e: IllegalArgumentException) {
                Logger.error(e, e.message ?: "Unknown enum value: $value")
                UNKNOWN
            }
        }

        override fun serialize(encoder: Encoder, value: PaymentChannel) {
            encoder.encodeString(value.name.lowercase())
        }
    }
}
