package com.paystack.android.core.api.models

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
internal data class ErrorResponse(
    val status: Boolean,

    @SerialName("message")
    private val fallbackMessage: String,

    private val data: ErrorBody? = null
) {

    /**
     * This is a convenience method to get the display message if it exists,
     * or the fallback message if it doesn't.
     * */
    val message: String
        get() = data?.message ?: fallbackMessage
}

@Serializable
internal data class ErrorBody internal constructor(
    @SerialName("message")
    val message: String? = null
)
