package com.paystack.android.core.api

import com.paystack.android.core.Paystack
import com.paystack.android.core.Paystack.Builder.Companion.instance
import com.paystack.android.core.api.services.cards.CardPaymentsService
import com.paystack.android.core.api.services.cards.CardPaymentsServiceImpl
import com.paystack.android.core.api.services.mobilemoney.MobileMoneyService
import com.paystack.android.core.api.services.mobilemoney.MobileMoneyServiceImpl
import com.paystack.android.core.api.services.transactions.PaystackTransactionService
import com.paystack.android.core.api.services.transactions.PaystackTransactionServiceImpl
import com.paystack.android.core.events.eventsComponent

val Paystack.transactions: PaystackTransactionService
    get() = PaystackTransactionServiceImpl(apiComponent(instance.config), eventsComponent())

val Paystack.cards: CardPaymentsService
    get() = CardPaymentsServiceImpl(apiComponent(instance.config), eventsComponent())

val Paystack.mobileMoney: MobileMoneyService
    get() = MobileMoneyServiceImpl(apiComponent(instance.config))
