package com.paystack.androiddesignsystem

import androidx.compose.foundation.isSystemInDarkTheme
import androidx.compose.runtime.*
import com.google.accompanist.systemuicontroller.rememberSystemUiController
import com.paystack.androiddesignsystem.colors.LocalColors
import com.paystack.androiddesignsystem.colors.PaystackColors
import com.paystack.androiddesignsystem.dimensions.LocalDimensions
import com.paystack.androiddesignsystem.dimensions.PaystackDimensions
import com.paystack.androiddesignsystem.typography.LocalTypography
import com.paystack.androiddesignsystem.typography.PaystackTypography

object PaystackTheme {
    val colors: PaystackColors
        @Composable
        @ReadOnlyComposable
        get() = LocalColors.current
    val typography: PaystackTypography
        @Composable
        @ReadOnlyComposable
        get() = LocalTypography.current
    val dimensions: PaystackDimensions
        @Composable
        @ReadOnlyComposable
        get() = LocalDimensions.current
}

@Composable
fun PaystackTheme(
    darkTheme: Boolean = isSystemInDarkTheme(),
    colors: PaystackColors = PaystackTheme.colors,
    content: @Composable () -> Unit
) {
    val systemUiController = rememberSystemUiController()
    val color =
        if (darkTheme) LocalColors.current.primaryColors.stackBlue else LocalColors.current.primaryColors.stackBlue
    SideEffect {
        systemUiController.setSystemBarsColor(
            color = color
        )
    }

    val rememberedColors = remember { colors.copy() }.apply { updateColorsFrom(colors) }
    CompositionLocalProvider(
        LocalColors provides rememberedColors,
    ) {
        content()
    }
}