/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.OrderApplicationContextShippingPreference;
import com.paypal.sdk.models.VaultInstructionAction;

public class VaultVenmoExperienceContext {
    private String brandName;
    private OrderApplicationContextShippingPreference shippingPreference;
    private VaultInstructionAction vaultInstruction;

    public VaultVenmoExperienceContext() {
        this.shippingPreference = OrderApplicationContextShippingPreference.GET_FROM_FILE;
        this.vaultInstruction = VaultInstructionAction.ON_CREATE_PAYMENT_TOKENS;
    }

    public VaultVenmoExperienceContext(String brandName, OrderApplicationContextShippingPreference shippingPreference, VaultInstructionAction vaultInstruction) {
        this.brandName = brandName;
        this.shippingPreference = shippingPreference;
        this.vaultInstruction = vaultInstruction;
    }

    @JsonGetter(value="brand_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBrandName() {
        return this.brandName;
    }

    @JsonSetter(value="brand_name")
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    @JsonGetter(value="shipping_preference")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderApplicationContextShippingPreference getShippingPreference() {
        return this.shippingPreference;
    }

    @JsonSetter(value="shipping_preference")
    public void setShippingPreference(OrderApplicationContextShippingPreference shippingPreference) {
        this.shippingPreference = shippingPreference;
    }

    @JsonGetter(value="vault_instruction")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public VaultInstructionAction getVaultInstruction() {
        return this.vaultInstruction;
    }

    @JsonSetter(value="vault_instruction")
    public void setVaultInstruction(VaultInstructionAction vaultInstruction) {
        this.vaultInstruction = vaultInstruction;
    }

    public String toString() {
        return "VaultVenmoExperienceContext [brandName=" + this.brandName + ", shippingPreference=" + (Object)((Object)this.shippingPreference) + ", vaultInstruction=" + (Object)((Object)this.vaultInstruction) + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().brandName(this.getBrandName()).shippingPreference(this.getShippingPreference()).vaultInstruction(this.getVaultInstruction());
        return builder;
    }

    public static class Builder {
        private String brandName;
        private OrderApplicationContextShippingPreference shippingPreference = OrderApplicationContextShippingPreference.GET_FROM_FILE;
        private VaultInstructionAction vaultInstruction = VaultInstructionAction.ON_CREATE_PAYMENT_TOKENS;

        public Builder brandName(String brandName) {
            this.brandName = brandName;
            return this;
        }

        public Builder shippingPreference(OrderApplicationContextShippingPreference shippingPreference) {
            this.shippingPreference = shippingPreference;
            return this;
        }

        public Builder vaultInstruction(VaultInstructionAction vaultInstruction) {
            this.vaultInstruction = vaultInstruction;
            return this;
        }

        public VaultVenmoExperienceContext build() {
            return new VaultVenmoExperienceContext(this.brandName, this.shippingPreference, this.vaultInstruction);
        }
    }
}

