/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public enum ShippingType {
    SHIPPING,
    PICKUP,
    PICKUP_IN_STORE,
    PICKUP_FROM_PERSON,
    _UNKNOWN;

    private static TreeMap<String, ShippingType> valueMap;
    private String value;

    @JsonCreator
    public static ShippingType constructFromString(String toConvert) throws IOException {
        ShippingType enumValue = ShippingType.fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    public static ShippingType fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public static List<String> toValue(List<ShippingType> toConvert) {
        if (toConvert == null) {
            return null;
        }
        ArrayList<String> convertedValues = new ArrayList<String>();
        for (ShippingType enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }

    static {
        valueMap = new TreeMap();
        ShippingType.SHIPPING.value = "SHIPPING";
        ShippingType.PICKUP.value = "PICKUP";
        ShippingType.PICKUP_IN_STORE.value = "PICKUP_IN_STORE";
        ShippingType.PICKUP_FROM_PERSON.value = "PICKUP_FROM_PERSON";
        ShippingType._UNKNOWN.value = null;
        valueMap.put("SHIPPING", SHIPPING);
        valueMap.put("PICKUP", PICKUP);
        valueMap.put("PICKUP_IN_STORE", PICKUP_IN_STORE);
        valueMap.put("PICKUP_FROM_PERSON", PICKUP_FROM_PERSON);
    }
}

