/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.PatchOp;
import com.paypal.sdk.utilities.JsonValue;

public class Patch {
    private PatchOp op;
    private String path;
    private JsonValue value;
    private String from;

    public Patch() {
    }

    public Patch(PatchOp op, String path, JsonValue value, String from) {
        this.op = op;
        this.path = path;
        this.value = value;
        this.from = from;
    }

    @JsonGetter(value="op")
    public PatchOp getOp() {
        return this.op;
    }

    @JsonSetter(value="op")
    public void setOp(PatchOp op) {
        this.op = op;
    }

    @JsonGetter(value="path")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPath() {
        return this.path;
    }

    @JsonSetter(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    @JsonGetter(value="value")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public JsonValue getValue() {
        return this.value;
    }

    @JsonSetter(value="value")
    public void setValue(JsonValue value) {
        this.value = value;
    }

    @JsonGetter(value="from")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFrom() {
        return this.from;
    }

    @JsonSetter(value="from")
    public void setFrom(String from) {
        this.from = from;
    }

    public String toString() {
        return "Patch [op=" + (Object)((Object)this.op) + ", path=" + this.path + ", value=" + (Object)((Object)this.value) + ", from=" + this.from + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.op).path(this.getPath()).value(this.getValue()).from(this.getFrom());
        return builder;
    }

    public static class Builder {
        private PatchOp op;
        private String path;
        private JsonValue value;
        private String from;

        public Builder() {
        }

        public Builder(PatchOp op) {
            this.op = op;
        }

        public Builder op(PatchOp op) {
            this.op = op;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder value(JsonValue value) {
            this.value = value;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Patch build() {
            return new Patch(this.op, this.path, this.value, this.from);
        }
    }
}

