/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

public class OAuthToken {
    private String accessToken;
    private String tokenType;
    private Long expiresIn;
    private String scope;
    private Long expiry;
    private String refreshToken;
    private String idToken;

    public OAuthToken() {
    }

    public OAuthToken(String accessToken, String tokenType, Long expiresIn, String scope, Long expiry, String refreshToken, String idToken) {
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
        this.scope = scope;
        this.expiry = expiry;
        this.refreshToken = refreshToken;
        this.idToken = idToken;
    }

    @JsonGetter(value="access_token")
    public String getAccessToken() {
        return this.accessToken;
    }

    @JsonSetter(value="access_token")
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @JsonGetter(value="token_type")
    public String getTokenType() {
        return this.tokenType;
    }

    @JsonSetter(value="token_type")
    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    @JsonGetter(value="expires_in")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getExpiresIn() {
        return this.expiresIn;
    }

    @JsonSetter(value="expires_in")
    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    @JsonGetter(value="scope")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getScope() {
        return this.scope;
    }

    @JsonSetter(value="scope")
    public void setScope(String scope) {
        this.scope = scope;
    }

    @JsonGetter(value="expiry")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getExpiry() {
        return this.expiry;
    }

    @JsonSetter(value="expiry")
    public void setExpiry(Long expiry) {
        this.expiry = expiry;
    }

    @JsonGetter(value="refresh_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @JsonSetter(value="refresh_token")
    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    @JsonGetter(value="id_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdToken() {
        return this.idToken;
    }

    @JsonSetter(value="id_token")
    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.accessToken, this.tokenType).expiresIn(this.getExpiresIn()).scope(this.getScope()).expiry(this.getExpiry()).refreshToken(this.getRefreshToken()).idToken(this.getIdToken());
        return builder;
    }

    public static class Builder {
        private String accessToken;
        private String tokenType;
        private Long expiresIn;
        private String scope;
        private Long expiry;
        private String refreshToken;
        private String idToken;

        public Builder() {
        }

        public Builder(String accessToken, String tokenType) {
            this.accessToken = accessToken;
            this.tokenType = tokenType;
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public Builder expiresIn(Long expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder expiry(Long expiry) {
            this.expiry = expiry;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        public OAuthToken build() {
            return new OAuthToken(this.accessToken, this.tokenType, this.expiresIn, this.scope, this.expiry, this.refreshToken, this.idToken);
        }
    }
}

