/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;

public class Money {
    private String currencyCode;
    private String value;

    public Money() {
    }

    public Money(String currencyCode, String value) {
        this.currencyCode = currencyCode;
        this.value = value;
    }

    @JsonGetter(value="currency_code")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonSetter(value="currency_code")
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    @JsonGetter(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonSetter(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "Money [currencyCode=" + this.currencyCode + ", value=" + this.value + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.currencyCode, this.value);
        return builder;
    }

    public static class Builder {
        private String currencyCode;
        private String value;

        public Builder() {
        }

        public Builder(String currencyCode, String value) {
            this.currencyCode = currencyCode;
            this.value = value;
        }

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Money build() {
            return new Money(this.currencyCode, this.value);
        }
    }
}

