/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public enum ItemCategory {
    DIGITAL_GOODS,
    PHYSICAL_GOODS,
    DONATION,
    _UNKNOWN;

    private static TreeMap<String, ItemCategory> valueMap;
    private String value;

    @JsonCreator
    public static ItemCategory constructFromString(String toConvert) throws IOException {
        ItemCategory enumValue = ItemCategory.fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    public static ItemCategory fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public static List<String> toValue(List<ItemCategory> toConvert) {
        if (toConvert == null) {
            return null;
        }
        ArrayList<String> convertedValues = new ArrayList<String>();
        for (ItemCategory enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }

    static {
        valueMap = new TreeMap();
        ItemCategory.DIGITAL_GOODS.value = "DIGITAL_GOODS";
        ItemCategory.PHYSICAL_GOODS.value = "PHYSICAL_GOODS";
        ItemCategory.DONATION.value = "DONATION";
        ItemCategory._UNKNOWN.value = null;
        valueMap.put("DIGITAL_GOODS", DIGITAL_GOODS);
        valueMap.put("PHYSICAL_GOODS", PHYSICAL_GOODS);
        valueMap.put("DONATION", DONATION);
    }
}

