/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.PaymentTokenRequest;

public class CreatePaymentTokenInput {
    private String contentType;
    private PaymentTokenRequest body;
    private String paypalRequestId;

    public CreatePaymentTokenInput() {
        this.contentType = "application/json";
    }

    public CreatePaymentTokenInput(String contentType, PaymentTokenRequest body, String paypalRequestId) {
        this.contentType = contentType;
        this.body = body;
        this.paypalRequestId = paypalRequestId;
    }

    @JsonGetter(value="Content-Type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonSetter(value="Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonGetter(value="body")
    public PaymentTokenRequest getBody() {
        return this.body;
    }

    @JsonSetter(value="body")
    public void setBody(PaymentTokenRequest body) {
        this.body = body;
    }

    @JsonGetter(value="PayPal-Request-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalRequestId() {
        return this.paypalRequestId;
    }

    @JsonSetter(value="PayPal-Request-Id")
    public void setPaypalRequestId(String paypalRequestId) {
        this.paypalRequestId = paypalRequestId;
    }

    public String toString() {
        return "CreatePaymentTokenInput [contentType=" + this.contentType + ", body=" + this.body + ", paypalRequestId=" + this.paypalRequestId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.contentType, this.body).paypalRequestId(this.getPaypalRequestId());
        return builder;
    }

    public static class Builder {
        private String contentType = "application/json";
        private PaymentTokenRequest body;
        private String paypalRequestId;

        public Builder() {
        }

        public Builder(String contentType, PaymentTokenRequest body) {
            this.contentType = contentType;
            this.body = body;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder body(PaymentTokenRequest body) {
            this.body = body;
            return this;
        }

        public Builder paypalRequestId(String paypalRequestId) {
            this.paypalRequestId = paypalRequestId;
            return this;
        }

        public CreatePaymentTokenInput build() {
            return new CreatePaymentTokenInput(this.contentType, this.body, this.paypalRequestId);
        }
    }
}

